// skip
// # generated by cmplxdivide.c

package main

import "math"

var (
	nan     = math.NaN()
	inf     = math.Inf(1)
	zero    = 0.0
)

var tests = []struct {
	f, g complex128
	out  complex128
}{
	{complex(zero, zero), complex(zero, zero), complex(nan, nan)},
	{complex(zero, zero), complex(zero, -zero), complex(nan, nan)},
	{complex(zero, zero), complex(zero, 1), complex(zero, zero)},
	{complex(zero, zero), complex(zero, -1), complex(-zero, zero)},
	{complex(zero, zero), complex(zero, 2), complex(zero, zero)},
	{complex(zero, zero), complex(nan, nan), complex(nan, nan)},
	{complex(zero, zero), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, zero), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, zero), complex(zero, zero), complex(nan, nan)},
	{complex(zero, zero), complex(-zero, -zero), complex(nan, nan)},
	{complex(zero, zero), complex(zero, 1), complex(zero, zero)},
	{complex(zero, zero), complex(-zero, -1), complex(-zero, -zero)},
	{complex(zero, zero), complex(zero, 2), complex(zero, zero)},
	{complex(zero, zero), complex(nan, nan), complex(nan, nan)},
	{complex(zero, zero), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, zero), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, zero), complex(1, zero), complex(zero, zero)},
	{complex(zero, zero), complex(1, -zero), complex(zero, zero)},
	{complex(zero, zero), complex(1, 1), complex(zero, zero)},
	{complex(zero, zero), complex(1, -1), complex(zero, zero)},
	{complex(zero, zero), complex(1, 2), complex(zero, zero)},
	{complex(zero, zero), complex(nan, nan), complex(nan, nan)},
	{complex(zero, zero), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, zero), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, zero), complex(-1, zero), complex(-zero, -zero)},
	{complex(zero, zero), complex(-1, -zero), complex(-zero, -zero)},
	{complex(zero, zero), complex(-1, 1), complex(-zero, -zero)},
	{complex(zero, zero), complex(-1, -1), complex(-zero, -zero)},
	{complex(zero, zero), complex(-1, 2), complex(zero, -zero)},
	{complex(zero, zero), complex(nan, nan), complex(nan, nan)},
	{complex(zero, zero), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, zero), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, zero), complex(2, zero), complex(zero, zero)},
	{complex(zero, zero), complex(2, -zero), complex(zero, zero)},
	{complex(zero, zero), complex(2, 1), complex(zero, zero)},
	{complex(zero, zero), complex(2, -1), complex(zero, zero)},
	{complex(zero, zero), complex(2, 2), complex(zero, zero)},
	{complex(zero, zero), complex(nan, nan), complex(nan, nan)},
	{complex(zero, zero), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, zero), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, zero), complex(nan, zero), complex(nan, nan)},
	{complex(zero, zero), complex(nan, -zero), complex(nan, nan)},
	{complex(zero, zero), complex(nan, 1), complex(nan, nan)},
	{complex(zero, zero), complex(nan, -1), complex(nan, nan)},
	{complex(zero, zero), complex(nan, 2), complex(nan, nan)},
	{complex(zero, zero), complex(nan, nan), complex(nan, nan)},
	{complex(zero, zero), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, zero), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, zero), complex(inf, zero), complex(zero, zero)},
	{complex(zero, zero), complex(inf, -zero), complex(zero, zero)},
	{complex(zero, zero), complex(inf, 1), complex(zero, zero)},
	{complex(zero, zero), complex(inf, -1), complex(zero, zero)},
	{complex(zero, zero), complex(inf, 2), complex(zero, zero)},
	{complex(zero, zero), complex(nan, nan), complex(nan, nan)},
	{complex(zero, zero), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, zero), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, zero), complex(-inf, zero), complex(-zero, -zero)},
	{complex(zero, zero), complex(-inf, -zero), complex(-zero, -zero)},
	{complex(zero, zero), complex(-inf, 1), complex(-zero, -zero)},
	{complex(zero, zero), complex(-inf, -1), complex(-zero, -zero)},
	{complex(zero, zero), complex(-inf, 2), complex(-zero, -zero)},
	{complex(zero, zero), complex(nan, nan), complex(nan, nan)},
	{complex(zero, zero), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, zero), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, -zero), complex(zero, zero), complex(nan, nan)},
	{complex(zero, -zero), complex(zero, -zero), complex(nan, nan)},
	{complex(zero, -zero), complex(zero, 1), complex(zero, -zero)},
	{complex(zero, -zero), complex(zero, -1), complex(zero, -zero)},
	{complex(zero, -zero), complex(zero, 2), complex(zero, -zero)},
	{complex(zero, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(zero, -zero), complex(nan, inf), complex(-zero, zero)},
	{complex(zero, -zero), complex(nan, -inf), complex(zero, zero)},
	{complex(zero, -zero), complex(zero, zero), complex(nan, nan)},
	{complex(zero, -zero), complex(-zero, -zero), complex(nan, nan)},
	{complex(zero, -zero), complex(zero, 1), complex(zero, -zero)},
	{complex(zero, -zero), complex(-zero, -1), complex(-zero, zero)},
	{complex(zero, -zero), complex(zero, 2), complex(zero, -zero)},
	{complex(zero, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(zero, -zero), complex(nan, inf), complex(-zero, zero)},
	{complex(zero, -zero), complex(nan, -inf), complex(zero, zero)},
	{complex(zero, -zero), complex(1, zero), complex(zero, -zero)},
	{complex(zero, -zero), complex(1, -zero), complex(zero, zero)},
	{complex(zero, -zero), complex(1, 1), complex(zero, -zero)},
	{complex(zero, -zero), complex(1, -1), complex(zero, zero)},
	{complex(zero, -zero), complex(1, 2), complex(zero, -zero)},
	{complex(zero, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(zero, -zero), complex(nan, inf), complex(-zero, zero)},
	{complex(zero, -zero), complex(nan, -inf), complex(zero, zero)},
	{complex(zero, -zero), complex(-1, zero), complex(-zero, -zero)},
	{complex(zero, -zero), complex(-1, -zero), complex(-zero, zero)},
	{complex(zero, -zero), complex(-1, 1), complex(-zero, -zero)},
	{complex(zero, -zero), complex(-1, -1), complex(-zero, zero)},
	{complex(zero, -zero), complex(-1, 2), complex(-zero, zero)},
	{complex(zero, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(zero, -zero), complex(nan, inf), complex(-zero, zero)},
	{complex(zero, -zero), complex(nan, -inf), complex(zero, zero)},
	{complex(zero, -zero), complex(2, zero), complex(zero, -zero)},
	{complex(zero, -zero), complex(2, -zero), complex(zero, zero)},
	{complex(zero, -zero), complex(2, 1), complex(zero, -zero)},
	{complex(zero, -zero), complex(2, -1), complex(zero, zero)},
	{complex(zero, -zero), complex(2, 2), complex(zero, -zero)},
	{complex(zero, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(zero, -zero), complex(nan, inf), complex(-zero, zero)},
	{complex(zero, -zero), complex(nan, -inf), complex(zero, zero)},
	{complex(zero, -zero), complex(nan, zero), complex(nan, nan)},
	{complex(zero, -zero), complex(nan, -zero), complex(nan, nan)},
	{complex(zero, -zero), complex(nan, 1), complex(nan, nan)},
	{complex(zero, -zero), complex(nan, -1), complex(nan, nan)},
	{complex(zero, -zero), complex(nan, 2), complex(nan, nan)},
	{complex(zero, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(zero, -zero), complex(nan, inf), complex(-zero, zero)},
	{complex(zero, -zero), complex(nan, -inf), complex(zero, zero)},
	{complex(zero, -zero), complex(inf, zero), complex(zero, -zero)},
	{complex(zero, -zero), complex(inf, -zero), complex(zero, zero)},
	{complex(zero, -zero), complex(inf, 1), complex(zero, -zero)},
	{complex(zero, -zero), complex(inf, -1), complex(zero, zero)},
	{complex(zero, -zero), complex(inf, 2), complex(zero, -zero)},
	{complex(zero, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(zero, -zero), complex(nan, inf), complex(-zero, zero)},
	{complex(zero, -zero), complex(nan, -inf), complex(zero, zero)},
	{complex(zero, -zero), complex(-inf, zero), complex(-zero, -zero)},
	{complex(zero, -zero), complex(-inf, -zero), complex(-zero, zero)},
	{complex(zero, -zero), complex(-inf, 1), complex(-zero, -zero)},
	{complex(zero, -zero), complex(-inf, -1), complex(-zero, zero)},
	{complex(zero, -zero), complex(-inf, 2), complex(-zero, -zero)},
	{complex(zero, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(zero, -zero), complex(nan, inf), complex(-zero, zero)},
	{complex(zero, -zero), complex(nan, -inf), complex(zero, zero)},
	{complex(zero, 1), complex(zero, zero), complex(nan, inf)},
	{complex(zero, 1), complex(zero, -zero), complex(nan, inf)},
	{complex(zero, 1), complex(zero, 1), complex(1, zero)},
	{complex(zero, 1), complex(zero, -1), complex(-1, zero)},
	{complex(zero, 1), complex(zero, 2), complex(0.5, zero)},
	{complex(zero, 1), complex(nan, nan), complex(nan, nan)},
	{complex(zero, 1), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, 1), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, 1), complex(zero, zero), complex(nan, inf)},
	{complex(zero, 1), complex(-zero, -zero), complex(nan, -inf)},
	{complex(zero, 1), complex(zero, 1), complex(1, zero)},
	{complex(zero, 1), complex(-zero, -1), complex(-1, -zero)},
	{complex(zero, 1), complex(zero, 2), complex(0.5, zero)},
	{complex(zero, 1), complex(nan, nan), complex(nan, nan)},
	{complex(zero, 1), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, 1), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, 1), complex(1, zero), complex(zero, 1)},
	{complex(zero, 1), complex(1, -zero), complex(zero, 1)},
	{complex(zero, 1), complex(1, 1), complex(0.5, 0.5)},
	{complex(zero, 1), complex(1, -1), complex(-0.5, 0.5)},
	{complex(zero, 1), complex(1, 2), complex(0.4, 0.2)},
	{complex(zero, 1), complex(nan, nan), complex(nan, nan)},
	{complex(zero, 1), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, 1), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, 1), complex(-1, zero), complex(-zero, -1)},
	{complex(zero, 1), complex(-1, -zero), complex(-zero, -1)},
	{complex(zero, 1), complex(-1, 1), complex(0.5, -0.5)},
	{complex(zero, 1), complex(-1, -1), complex(-0.5, -0.5)},
	{complex(zero, 1), complex(-1, 2), complex(0.4, -0.2)},
	{complex(zero, 1), complex(nan, nan), complex(nan, nan)},
	{complex(zero, 1), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, 1), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, 1), complex(2, zero), complex(zero, 0.5)},
	{complex(zero, 1), complex(2, -zero), complex(zero, 0.5)},
	{complex(zero, 1), complex(2, 1), complex(0.2, 0.4)},
	{complex(zero, 1), complex(2, -1), complex(-0.2, 0.4)},
	{complex(zero, 1), complex(2, 2), complex(0.25, 0.25)},
	{complex(zero, 1), complex(nan, nan), complex(nan, nan)},
	{complex(zero, 1), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, 1), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, 1), complex(nan, zero), complex(nan, nan)},
	{complex(zero, 1), complex(nan, -zero), complex(nan, nan)},
	{complex(zero, 1), complex(nan, 1), complex(nan, nan)},
	{complex(zero, 1), complex(nan, -1), complex(nan, nan)},
	{complex(zero, 1), complex(nan, 2), complex(nan, nan)},
	{complex(zero, 1), complex(nan, nan), complex(nan, nan)},
	{complex(zero, 1), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, 1), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, 1), complex(inf, zero), complex(zero, zero)},
	{complex(zero, 1), complex(inf, -zero), complex(zero, zero)},
	{complex(zero, 1), complex(inf, 1), complex(zero, zero)},
	{complex(zero, 1), complex(inf, -1), complex(zero, zero)},
	{complex(zero, 1), complex(inf, 2), complex(zero, zero)},
	{complex(zero, 1), complex(nan, nan), complex(nan, nan)},
	{complex(zero, 1), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, 1), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, 1), complex(-inf, zero), complex(-zero, -zero)},
	{complex(zero, 1), complex(-inf, -zero), complex(-zero, -zero)},
	{complex(zero, 1), complex(-inf, 1), complex(-zero, -zero)},
	{complex(zero, 1), complex(-inf, -1), complex(-zero, -zero)},
	{complex(zero, 1), complex(-inf, 2), complex(-zero, -zero)},
	{complex(zero, 1), complex(nan, nan), complex(nan, nan)},
	{complex(zero, 1), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, 1), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, -1), complex(zero, zero), complex(nan, -inf)},
	{complex(zero, -1), complex(zero, -zero), complex(nan, -inf)},
	{complex(zero, -1), complex(zero, 1), complex(-1, -zero)},
	{complex(zero, -1), complex(zero, -1), complex(1, -zero)},
	{complex(zero, -1), complex(zero, 2), complex(-0.5, -zero)},
	{complex(zero, -1), complex(nan, nan), complex(nan, nan)},
	{complex(zero, -1), complex(nan, inf), complex(-zero, zero)},
	{complex(zero, -1), complex(nan, -inf), complex(zero, zero)},
	{complex(zero, -1), complex(zero, zero), complex(nan, -inf)},
	{complex(zero, -1), complex(-zero, -zero), complex(nan, inf)},
	{complex(zero, -1), complex(zero, 1), complex(-1, -zero)},
	{complex(zero, -1), complex(-zero, -1), complex(1, zero)},
	{complex(zero, -1), complex(zero, 2), complex(-0.5, -zero)},
	{complex(zero, -1), complex(nan, nan), complex(nan, nan)},
	{complex(zero, -1), complex(nan, inf), complex(-zero, zero)},
	{complex(zero, -1), complex(nan, -inf), complex(zero, zero)},
	{complex(zero, -1), complex(1, zero), complex(zero, -1)},
	{complex(zero, -1), complex(1, -zero), complex(zero, -1)},
	{complex(zero, -1), complex(1, 1), complex(-0.5, -0.5)},
	{complex(zero, -1), complex(1, -1), complex(0.5, -0.5)},
	{complex(zero, -1), complex(1, 2), complex(-0.4, -0.2)},
	{complex(zero, -1), complex(nan, nan), complex(nan, nan)},
	{complex(zero, -1), complex(nan, inf), complex(-zero, zero)},
	{complex(zero, -1), complex(nan, -inf), complex(zero, zero)},
	{complex(zero, -1), complex(-1, zero), complex(-zero, 1)},
	{complex(zero, -1), complex(-1, -zero), complex(-zero, 1)},
	{complex(zero, -1), complex(-1, 1), complex(-0.5, 0.5)},
	{complex(zero, -1), complex(-1, -1), complex(0.5, 0.5)},
	{complex(zero, -1), complex(-1, 2), complex(-0.4, 0.2)},
	{complex(zero, -1), complex(nan, nan), complex(nan, nan)},
	{complex(zero, -1), complex(nan, inf), complex(-zero, zero)},
	{complex(zero, -1), complex(nan, -inf), complex(zero, zero)},
	{complex(zero, -1), complex(2, zero), complex(zero, -0.5)},
	{complex(zero, -1), complex(2, -zero), complex(zero, -0.5)},
	{complex(zero, -1), complex(2, 1), complex(-0.2, -0.4)},
	{complex(zero, -1), complex(2, -1), complex(0.2, -0.4)},
	{complex(zero, -1), complex(2, 2), complex(-0.25, -0.25)},
	{complex(zero, -1), complex(nan, nan), complex(nan, nan)},
	{complex(zero, -1), complex(nan, inf), complex(-zero, zero)},
	{complex(zero, -1), complex(nan, -inf), complex(zero, zero)},
	{complex(zero, -1), complex(nan, zero), complex(nan, nan)},
	{complex(zero, -1), complex(nan, -zero), complex(nan, nan)},
	{complex(zero, -1), complex(nan, 1), complex(nan, nan)},
	{complex(zero, -1), complex(nan, -1), complex(nan, nan)},
	{complex(zero, -1), complex(nan, 2), complex(nan, nan)},
	{complex(zero, -1), complex(nan, nan), complex(nan, nan)},
	{complex(zero, -1), complex(nan, inf), complex(-zero, zero)},
	{complex(zero, -1), complex(nan, -inf), complex(zero, zero)},
	{complex(zero, -1), complex(inf, zero), complex(zero, -zero)},
	{complex(zero, -1), complex(inf, -zero), complex(zero, -zero)},
	{complex(zero, -1), complex(inf, 1), complex(zero, -zero)},
	{complex(zero, -1), complex(inf, -1), complex(zero, -zero)},
	{complex(zero, -1), complex(inf, 2), complex(zero, -zero)},
	{complex(zero, -1), complex(nan, nan), complex(nan, nan)},
	{complex(zero, -1), complex(nan, inf), complex(-zero, zero)},
	{complex(zero, -1), complex(nan, -inf), complex(zero, zero)},
	{complex(zero, -1), complex(-inf, zero), complex(-zero, zero)},
	{complex(zero, -1), complex(-inf, -zero), complex(-zero, zero)},
	{complex(zero, -1), complex(-inf, 1), complex(-zero, zero)},
	{complex(zero, -1), complex(-inf, -1), complex(-zero, zero)},
	{complex(zero, -1), complex(-inf, 2), complex(-zero, zero)},
	{complex(zero, -1), complex(nan, nan), complex(nan, nan)},
	{complex(zero, -1), complex(nan, inf), complex(-zero, zero)},
	{complex(zero, -1), complex(nan, -inf), complex(zero, zero)},
	{complex(zero, 2), complex(zero, zero), complex(nan, inf)},
	{complex(zero, 2), complex(zero, -zero), complex(nan, inf)},
	{complex(zero, 2), complex(zero, 1), complex(2, zero)},
	{complex(zero, 2), complex(zero, -1), complex(-2, zero)},
	{complex(zero, 2), complex(zero, 2), complex(1, zero)},
	{complex(zero, 2), complex(nan, nan), complex(nan, nan)},
	{complex(zero, 2), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, 2), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, 2), complex(zero, zero), complex(nan, inf)},
	{complex(zero, 2), complex(-zero, -zero), complex(nan, -inf)},
	{complex(zero, 2), complex(zero, 1), complex(2, zero)},
	{complex(zero, 2), complex(-zero, -1), complex(-2, -zero)},
	{complex(zero, 2), complex(zero, 2), complex(1, zero)},
	{complex(zero, 2), complex(nan, nan), complex(nan, nan)},
	{complex(zero, 2), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, 2), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, 2), complex(1, zero), complex(zero, 2)},
	{complex(zero, 2), complex(1, -zero), complex(zero, 2)},
	{complex(zero, 2), complex(1, 1), complex(1, 1)},
	{complex(zero, 2), complex(1, -1), complex(-1, 1)},
	{complex(zero, 2), complex(1, 2), complex(0.8, 0.4)},
	{complex(zero, 2), complex(nan, nan), complex(nan, nan)},
	{complex(zero, 2), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, 2), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, 2), complex(-1, zero), complex(-zero, -2)},
	{complex(zero, 2), complex(-1, -zero), complex(-zero, -2)},
	{complex(zero, 2), complex(-1, 1), complex(1, -1)},
	{complex(zero, 2), complex(-1, -1), complex(-1, -1)},
	{complex(zero, 2), complex(-1, 2), complex(0.8, -0.4)},
	{complex(zero, 2), complex(nan, nan), complex(nan, nan)},
	{complex(zero, 2), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, 2), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, 2), complex(2, zero), complex(zero, 1)},
	{complex(zero, 2), complex(2, -zero), complex(zero, 1)},
	{complex(zero, 2), complex(2, 1), complex(0.4, 0.8)},
	{complex(zero, 2), complex(2, -1), complex(-0.4, 0.8)},
	{complex(zero, 2), complex(2, 2), complex(0.5, 0.5)},
	{complex(zero, 2), complex(nan, nan), complex(nan, nan)},
	{complex(zero, 2), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, 2), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, 2), complex(nan, zero), complex(nan, nan)},
	{complex(zero, 2), complex(nan, -zero), complex(nan, nan)},
	{complex(zero, 2), complex(nan, 1), complex(nan, nan)},
	{complex(zero, 2), complex(nan, -1), complex(nan, nan)},
	{complex(zero, 2), complex(nan, 2), complex(nan, nan)},
	{complex(zero, 2), complex(nan, nan), complex(nan, nan)},
	{complex(zero, 2), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, 2), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, 2), complex(inf, zero), complex(zero, zero)},
	{complex(zero, 2), complex(inf, -zero), complex(zero, zero)},
	{complex(zero, 2), complex(inf, 1), complex(zero, zero)},
	{complex(zero, 2), complex(inf, -1), complex(zero, zero)},
	{complex(zero, 2), complex(inf, 2), complex(zero, zero)},
	{complex(zero, 2), complex(nan, nan), complex(nan, nan)},
	{complex(zero, 2), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, 2), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, 2), complex(-inf, zero), complex(-zero, -zero)},
	{complex(zero, 2), complex(-inf, -zero), complex(-zero, -zero)},
	{complex(zero, 2), complex(-inf, 1), complex(-zero, -zero)},
	{complex(zero, 2), complex(-inf, -1), complex(-zero, -zero)},
	{complex(zero, 2), complex(-inf, 2), complex(-zero, -zero)},
	{complex(zero, 2), complex(nan, nan), complex(nan, nan)},
	{complex(zero, 2), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, 2), complex(nan, -inf), complex(-zero, zero)},
	{complex(nan, nan), complex(zero, zero), complex(nan, nan)},
	{complex(nan, nan), complex(zero, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(zero, 1), complex(nan, nan)},
	{complex(nan, nan), complex(zero, -1), complex(nan, nan)},
	{complex(nan, nan), complex(zero, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(zero, zero), complex(nan, nan)},
	{complex(nan, nan), complex(-zero, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(zero, 1), complex(nan, nan)},
	{complex(nan, nan), complex(-zero, -1), complex(nan, nan)},
	{complex(nan, nan), complex(zero, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(1, zero), complex(nan, nan)},
	{complex(nan, nan), complex(1, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(1, 1), complex(nan, nan)},
	{complex(nan, nan), complex(1, -1), complex(nan, nan)},
	{complex(nan, nan), complex(1, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(-1, zero), complex(nan, nan)},
	{complex(nan, nan), complex(-1, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(-1, 1), complex(nan, nan)},
	{complex(nan, nan), complex(-1, -1), complex(nan, nan)},
	{complex(nan, nan), complex(-1, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(2, zero), complex(nan, nan)},
	{complex(nan, nan), complex(2, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(2, 1), complex(nan, nan)},
	{complex(nan, nan), complex(2, -1), complex(nan, nan)},
	{complex(nan, nan), complex(2, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, zero), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(nan, 1), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -1), complex(nan, nan)},
	{complex(nan, nan), complex(nan, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(inf, zero), complex(nan, nan)},
	{complex(nan, nan), complex(inf, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(inf, 1), complex(nan, nan)},
	{complex(nan, nan), complex(inf, -1), complex(nan, nan)},
	{complex(nan, nan), complex(inf, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, zero), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, 1), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, -1), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(zero, zero), complex(nan, inf)},
	{complex(nan, inf), complex(zero, -zero), complex(nan, inf)},
	{complex(nan, inf), complex(zero, 1), complex(inf, nan)},
	{complex(nan, inf), complex(zero, -1), complex(-inf, nan)},
	{complex(nan, inf), complex(zero, 2), complex(inf, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(zero, zero), complex(nan, inf)},
	{complex(nan, inf), complex(-zero, -zero), complex(nan, -inf)},
	{complex(nan, inf), complex(zero, 1), complex(inf, nan)},
	{complex(nan, inf), complex(-zero, -1), complex(-inf, nan)},
	{complex(nan, inf), complex(zero, 2), complex(inf, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(1, zero), complex(nan, inf)},
	{complex(nan, inf), complex(1, -zero), complex(nan, inf)},
	{complex(nan, inf), complex(1, 1), complex(inf, inf)},
	{complex(nan, inf), complex(1, -1), complex(-inf, inf)},
	{complex(nan, inf), complex(1, 2), complex(inf, inf)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(-1, zero), complex(nan, -inf)},
	{complex(nan, inf), complex(-1, -zero), complex(nan, -inf)},
	{complex(nan, inf), complex(-1, 1), complex(inf, -inf)},
	{complex(nan, inf), complex(-1, -1), complex(-inf, -inf)},
	{complex(nan, inf), complex(-1, 2), complex(inf, -inf)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(2, zero), complex(nan, inf)},
	{complex(nan, inf), complex(2, -zero), complex(nan, inf)},
	{complex(nan, inf), complex(2, 1), complex(inf, inf)},
	{complex(nan, inf), complex(2, -1), complex(-inf, inf)},
	{complex(nan, inf), complex(2, 2), complex(inf, inf)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, zero), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -zero), complex(nan, nan)},
	{complex(nan, inf), complex(nan, 1), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -1), complex(nan, nan)},
	{complex(nan, inf), complex(nan, 2), complex(nan, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(inf, zero), complex(nan, nan)},
	{complex(nan, inf), complex(inf, -zero), complex(nan, nan)},
	{complex(nan, inf), complex(inf, 1), complex(nan, nan)},
	{complex(nan, inf), complex(inf, -1), complex(nan, nan)},
	{complex(nan, inf), complex(inf, 2), complex(nan, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, zero), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, -zero), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, 1), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, -1), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, 2), complex(nan, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(zero, zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(zero, -zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(zero, 1), complex(-inf, nan)},
	{complex(nan, -inf), complex(zero, -1), complex(inf, nan)},
	{complex(nan, -inf), complex(zero, 2), complex(-inf, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(zero, zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(-zero, -zero), complex(nan, inf)},
	{complex(nan, -inf), complex(zero, 1), complex(-inf, nan)},
	{complex(nan, -inf), complex(-zero, -1), complex(inf, nan)},
	{complex(nan, -inf), complex(zero, 2), complex(-inf, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(1, zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(1, -zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(1, 1), complex(-inf, -inf)},
	{complex(nan, -inf), complex(1, -1), complex(inf, -inf)},
	{complex(nan, -inf), complex(1, 2), complex(-inf, -inf)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(-1, zero), complex(nan, inf)},
	{complex(nan, -inf), complex(-1, -zero), complex(nan, inf)},
	{complex(nan, -inf), complex(-1, 1), complex(-inf, inf)},
	{complex(nan, -inf), complex(-1, -1), complex(inf, inf)},
	{complex(nan, -inf), complex(-1, 2), complex(-inf, inf)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(2, zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(2, -zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(2, 1), complex(-inf, -inf)},
	{complex(nan, -inf), complex(2, -1), complex(inf, -inf)},
	{complex(nan, -inf), complex(2, 2), complex(-inf, -inf)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, zero), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -zero), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, 1), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -1), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, 2), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, zero), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, -zero), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, 1), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, -1), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, 2), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, zero), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, -zero), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, 1), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, -1), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, 2), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(zero, zero), complex(zero, zero), complex(nan, nan)},
	{complex(zero, zero), complex(zero, -zero), complex(nan, nan)},
	{complex(zero, zero), complex(zero, 1), complex(zero, zero)},
	{complex(zero, zero), complex(zero, -1), complex(-zero, zero)},
	{complex(zero, zero), complex(zero, 2), complex(zero, zero)},
	{complex(zero, zero), complex(nan, nan), complex(nan, nan)},
	{complex(zero, zero), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, zero), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, zero), complex(zero, zero), complex(nan, nan)},
	{complex(zero, zero), complex(-zero, -zero), complex(nan, nan)},
	{complex(zero, zero), complex(zero, 1), complex(zero, zero)},
	{complex(zero, zero), complex(-zero, -1), complex(-zero, -zero)},
	{complex(zero, zero), complex(zero, 2), complex(zero, zero)},
	{complex(zero, zero), complex(nan, nan), complex(nan, nan)},
	{complex(zero, zero), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, zero), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, zero), complex(1, zero), complex(zero, zero)},
	{complex(zero, zero), complex(1, -zero), complex(zero, zero)},
	{complex(zero, zero), complex(1, 1), complex(zero, zero)},
	{complex(zero, zero), complex(1, -1), complex(zero, zero)},
	{complex(zero, zero), complex(1, 2), complex(zero, zero)},
	{complex(zero, zero), complex(nan, nan), complex(nan, nan)},
	{complex(zero, zero), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, zero), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, zero), complex(-1, zero), complex(-zero, -zero)},
	{complex(zero, zero), complex(-1, -zero), complex(-zero, -zero)},
	{complex(zero, zero), complex(-1, 1), complex(-zero, -zero)},
	{complex(zero, zero), complex(-1, -1), complex(-zero, -zero)},
	{complex(zero, zero), complex(-1, 2), complex(zero, -zero)},
	{complex(zero, zero), complex(nan, nan), complex(nan, nan)},
	{complex(zero, zero), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, zero), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, zero), complex(2, zero), complex(zero, zero)},
	{complex(zero, zero), complex(2, -zero), complex(zero, zero)},
	{complex(zero, zero), complex(2, 1), complex(zero, zero)},
	{complex(zero, zero), complex(2, -1), complex(zero, zero)},
	{complex(zero, zero), complex(2, 2), complex(zero, zero)},
	{complex(zero, zero), complex(nan, nan), complex(nan, nan)},
	{complex(zero, zero), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, zero), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, zero), complex(nan, zero), complex(nan, nan)},
	{complex(zero, zero), complex(nan, -zero), complex(nan, nan)},
	{complex(zero, zero), complex(nan, 1), complex(nan, nan)},
	{complex(zero, zero), complex(nan, -1), complex(nan, nan)},
	{complex(zero, zero), complex(nan, 2), complex(nan, nan)},
	{complex(zero, zero), complex(nan, nan), complex(nan, nan)},
	{complex(zero, zero), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, zero), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, zero), complex(inf, zero), complex(zero, zero)},
	{complex(zero, zero), complex(inf, -zero), complex(zero, zero)},
	{complex(zero, zero), complex(inf, 1), complex(zero, zero)},
	{complex(zero, zero), complex(inf, -1), complex(zero, zero)},
	{complex(zero, zero), complex(inf, 2), complex(zero, zero)},
	{complex(zero, zero), complex(nan, nan), complex(nan, nan)},
	{complex(zero, zero), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, zero), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, zero), complex(-inf, zero), complex(-zero, -zero)},
	{complex(zero, zero), complex(-inf, -zero), complex(-zero, -zero)},
	{complex(zero, zero), complex(-inf, 1), complex(-zero, -zero)},
	{complex(zero, zero), complex(-inf, -1), complex(-zero, -zero)},
	{complex(zero, zero), complex(-inf, 2), complex(-zero, -zero)},
	{complex(zero, zero), complex(nan, nan), complex(nan, nan)},
	{complex(zero, zero), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, zero), complex(nan, -inf), complex(-zero, zero)},
	{complex(-zero, -zero), complex(zero, zero), complex(nan, nan)},
	{complex(-zero, -zero), complex(zero, -zero), complex(nan, nan)},
	{complex(-zero, -zero), complex(zero, 1), complex(-zero, zero)},
	{complex(-zero, -zero), complex(zero, -1), complex(-zero, -zero)},
	{complex(-zero, -zero), complex(zero, 2), complex(-zero, zero)},
	{complex(-zero, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(-zero, -zero), complex(nan, inf), complex(zero, zero)},
	{complex(-zero, -zero), complex(nan, -inf), complex(zero, zero)},
	{complex(-zero, -zero), complex(zero, zero), complex(nan, nan)},
	{complex(-zero, -zero), complex(-zero, -zero), complex(nan, nan)},
	{complex(-zero, -zero), complex(zero, 1), complex(-zero, zero)},
	{complex(-zero, -zero), complex(-zero, -1), complex(zero, -zero)},
	{complex(-zero, -zero), complex(zero, 2), complex(-zero, zero)},
	{complex(-zero, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(-zero, -zero), complex(nan, inf), complex(zero, zero)},
	{complex(-zero, -zero), complex(nan, -inf), complex(zero, zero)},
	{complex(-zero, -zero), complex(1, zero), complex(-zero, zero)},
	{complex(-zero, -zero), complex(1, -zero), complex(zero, -zero)},
	{complex(-zero, -zero), complex(1, 1), complex(-zero, zero)},
	{complex(-zero, -zero), complex(1, -1), complex(zero, -zero)},
	{complex(-zero, -zero), complex(1, 2), complex(-zero, zero)},
	{complex(-zero, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(-zero, -zero), complex(nan, inf), complex(zero, zero)},
	{complex(-zero, -zero), complex(nan, -inf), complex(zero, zero)},
	{complex(-zero, -zero), complex(-1, zero), complex(-zero, zero)},
	{complex(-zero, -zero), complex(-1, -zero), complex(zero, -zero)},
	{complex(-zero, -zero), complex(-1, 1), complex(-zero, zero)},
	{complex(-zero, -zero), complex(-1, -1), complex(zero, -zero)},
	{complex(-zero, -zero), complex(-1, 2), complex(zero, zero)},
	{complex(-zero, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(-zero, -zero), complex(nan, inf), complex(zero, zero)},
	{complex(-zero, -zero), complex(nan, -inf), complex(zero, zero)},
	{complex(-zero, -zero), complex(2, zero), complex(-zero, zero)},
	{complex(-zero, -zero), complex(2, -zero), complex(zero, -zero)},
	{complex(-zero, -zero), complex(2, 1), complex(-zero, zero)},
	{complex(-zero, -zero), complex(2, -1), complex(zero, -zero)},
	{complex(-zero, -zero), complex(2, 2), complex(-zero, zero)},
	{complex(-zero, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(-zero, -zero), complex(nan, inf), complex(zero, zero)},
	{complex(-zero, -zero), complex(nan, -inf), complex(zero, zero)},
	{complex(-zero, -zero), complex(nan, zero), complex(nan, nan)},
	{complex(-zero, -zero), complex(nan, -zero), complex(nan, nan)},
	{complex(-zero, -zero), complex(nan, 1), complex(nan, nan)},
	{complex(-zero, -zero), complex(nan, -1), complex(nan, nan)},
	{complex(-zero, -zero), complex(nan, 2), complex(nan, nan)},
	{complex(-zero, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(-zero, -zero), complex(nan, inf), complex(zero, zero)},
	{complex(-zero, -zero), complex(nan, -inf), complex(zero, zero)},
	{complex(-zero, -zero), complex(inf, zero), complex(-zero, zero)},
	{complex(-zero, -zero), complex(inf, -zero), complex(zero, -zero)},
	{complex(-zero, -zero), complex(inf, 1), complex(-zero, zero)},
	{complex(-zero, -zero), complex(inf, -1), complex(zero, -zero)},
	{complex(-zero, -zero), complex(inf, 2), complex(-zero, zero)},
	{complex(-zero, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(-zero, -zero), complex(nan, inf), complex(zero, zero)},
	{complex(-zero, -zero), complex(nan, -inf), complex(zero, zero)},
	{complex(-zero, -zero), complex(-inf, zero), complex(-zero, zero)},
	{complex(-zero, -zero), complex(-inf, -zero), complex(zero, -zero)},
	{complex(-zero, -zero), complex(-inf, 1), complex(-zero, zero)},
	{complex(-zero, -zero), complex(-inf, -1), complex(zero, -zero)},
	{complex(-zero, -zero), complex(-inf, 2), complex(-zero, zero)},
	{complex(-zero, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(-zero, -zero), complex(nan, inf), complex(zero, zero)},
	{complex(-zero, -zero), complex(nan, -inf), complex(zero, zero)},
	{complex(zero, 1), complex(zero, zero), complex(nan, inf)},
	{complex(zero, 1), complex(zero, -zero), complex(nan, inf)},
	{complex(zero, 1), complex(zero, 1), complex(1, zero)},
	{complex(zero, 1), complex(zero, -1), complex(-1, zero)},
	{complex(zero, 1), complex(zero, 2), complex(0.5, zero)},
	{complex(zero, 1), complex(nan, nan), complex(nan, nan)},
	{complex(zero, 1), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, 1), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, 1), complex(zero, zero), complex(nan, inf)},
	{complex(zero, 1), complex(-zero, -zero), complex(nan, -inf)},
	{complex(zero, 1), complex(zero, 1), complex(1, zero)},
	{complex(zero, 1), complex(-zero, -1), complex(-1, -zero)},
	{complex(zero, 1), complex(zero, 2), complex(0.5, zero)},
	{complex(zero, 1), complex(nan, nan), complex(nan, nan)},
	{complex(zero, 1), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, 1), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, 1), complex(1, zero), complex(zero, 1)},
	{complex(zero, 1), complex(1, -zero), complex(zero, 1)},
	{complex(zero, 1), complex(1, 1), complex(0.5, 0.5)},
	{complex(zero, 1), complex(1, -1), complex(-0.5, 0.5)},
	{complex(zero, 1), complex(1, 2), complex(0.4, 0.2)},
	{complex(zero, 1), complex(nan, nan), complex(nan, nan)},
	{complex(zero, 1), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, 1), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, 1), complex(-1, zero), complex(-zero, -1)},
	{complex(zero, 1), complex(-1, -zero), complex(-zero, -1)},
	{complex(zero, 1), complex(-1, 1), complex(0.5, -0.5)},
	{complex(zero, 1), complex(-1, -1), complex(-0.5, -0.5)},
	{complex(zero, 1), complex(-1, 2), complex(0.4, -0.2)},
	{complex(zero, 1), complex(nan, nan), complex(nan, nan)},
	{complex(zero, 1), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, 1), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, 1), complex(2, zero), complex(zero, 0.5)},
	{complex(zero, 1), complex(2, -zero), complex(zero, 0.5)},
	{complex(zero, 1), complex(2, 1), complex(0.2, 0.4)},
	{complex(zero, 1), complex(2, -1), complex(-0.2, 0.4)},
	{complex(zero, 1), complex(2, 2), complex(0.25, 0.25)},
	{complex(zero, 1), complex(nan, nan), complex(nan, nan)},
	{complex(zero, 1), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, 1), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, 1), complex(nan, zero), complex(nan, nan)},
	{complex(zero, 1), complex(nan, -zero), complex(nan, nan)},
	{complex(zero, 1), complex(nan, 1), complex(nan, nan)},
	{complex(zero, 1), complex(nan, -1), complex(nan, nan)},
	{complex(zero, 1), complex(nan, 2), complex(nan, nan)},
	{complex(zero, 1), complex(nan, nan), complex(nan, nan)},
	{complex(zero, 1), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, 1), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, 1), complex(inf, zero), complex(zero, zero)},
	{complex(zero, 1), complex(inf, -zero), complex(zero, zero)},
	{complex(zero, 1), complex(inf, 1), complex(zero, zero)},
	{complex(zero, 1), complex(inf, -1), complex(zero, zero)},
	{complex(zero, 1), complex(inf, 2), complex(zero, zero)},
	{complex(zero, 1), complex(nan, nan), complex(nan, nan)},
	{complex(zero, 1), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, 1), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, 1), complex(-inf, zero), complex(-zero, -zero)},
	{complex(zero, 1), complex(-inf, -zero), complex(-zero, -zero)},
	{complex(zero, 1), complex(-inf, 1), complex(-zero, -zero)},
	{complex(zero, 1), complex(-inf, -1), complex(-zero, -zero)},
	{complex(zero, 1), complex(-inf, 2), complex(-zero, -zero)},
	{complex(zero, 1), complex(nan, nan), complex(nan, nan)},
	{complex(zero, 1), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, 1), complex(nan, -inf), complex(-zero, zero)},
	{complex(-zero, -1), complex(zero, zero), complex(nan, -inf)},
	{complex(-zero, -1), complex(zero, -zero), complex(nan, -inf)},
	{complex(-zero, -1), complex(zero, 1), complex(-1, zero)},
	{complex(-zero, -1), complex(zero, -1), complex(1, -zero)},
	{complex(-zero, -1), complex(zero, 2), complex(-0.5, zero)},
	{complex(-zero, -1), complex(nan, nan), complex(nan, nan)},
	{complex(-zero, -1), complex(nan, inf), complex(-zero, zero)},
	{complex(-zero, -1), complex(nan, -inf), complex(zero, zero)},
	{complex(-zero, -1), complex(zero, zero), complex(nan, -inf)},
	{complex(-zero, -1), complex(-zero, -zero), complex(nan, inf)},
	{complex(-zero, -1), complex(zero, 1), complex(-1, zero)},
	{complex(-zero, -1), complex(-zero, -1), complex(1, -zero)},
	{complex(-zero, -1), complex(zero, 2), complex(-0.5, zero)},
	{complex(-zero, -1), complex(nan, nan), complex(nan, nan)},
	{complex(-zero, -1), complex(nan, inf), complex(-zero, zero)},
	{complex(-zero, -1), complex(nan, -inf), complex(zero, zero)},
	{complex(-zero, -1), complex(1, zero), complex(-zero, -1)},
	{complex(-zero, -1), complex(1, -zero), complex(zero, -1)},
	{complex(-zero, -1), complex(1, 1), complex(-0.5, -0.5)},
	{complex(-zero, -1), complex(1, -1), complex(0.5, -0.5)},
	{complex(-zero, -1), complex(1, 2), complex(-0.4, -0.2)},
	{complex(-zero, -1), complex(nan, nan), complex(nan, nan)},
	{complex(-zero, -1), complex(nan, inf), complex(-zero, zero)},
	{complex(-zero, -1), complex(nan, -inf), complex(zero, zero)},
	{complex(-zero, -1), complex(-1, zero), complex(-zero, 1)},
	{complex(-zero, -1), complex(-1, -zero), complex(zero, 1)},
	{complex(-zero, -1), complex(-1, 1), complex(-0.5, 0.5)},
	{complex(-zero, -1), complex(-1, -1), complex(0.5, 0.5)},
	{complex(-zero, -1), complex(-1, 2), complex(-0.4, 0.2)},
	{complex(-zero, -1), complex(nan, nan), complex(nan, nan)},
	{complex(-zero, -1), complex(nan, inf), complex(-zero, zero)},
	{complex(-zero, -1), complex(nan, -inf), complex(zero, zero)},
	{complex(-zero, -1), complex(2, zero), complex(-zero, -0.5)},
	{complex(-zero, -1), complex(2, -zero), complex(zero, -0.5)},
	{complex(-zero, -1), complex(2, 1), complex(-0.2, -0.4)},
	{complex(-zero, -1), complex(2, -1), complex(0.2, -0.4)},
	{complex(-zero, -1), complex(2, 2), complex(-0.25, -0.25)},
	{complex(-zero, -1), complex(nan, nan), complex(nan, nan)},
	{complex(-zero, -1), complex(nan, inf), complex(-zero, zero)},
	{complex(-zero, -1), complex(nan, -inf), complex(zero, zero)},
	{complex(-zero, -1), complex(nan, zero), complex(nan, nan)},
	{complex(-zero, -1), complex(nan, -zero), complex(nan, nan)},
	{complex(-zero, -1), complex(nan, 1), complex(nan, nan)},
	{complex(-zero, -1), complex(nan, -1), complex(nan, nan)},
	{complex(-zero, -1), complex(nan, 2), complex(nan, nan)},
	{complex(-zero, -1), complex(nan, nan), complex(nan, nan)},
	{complex(-zero, -1), complex(nan, inf), complex(-zero, zero)},
	{complex(-zero, -1), complex(nan, -inf), complex(zero, zero)},
	{complex(-zero, -1), complex(inf, zero), complex(-zero, -zero)},
	{complex(-zero, -1), complex(inf, -zero), complex(zero, -zero)},
	{complex(-zero, -1), complex(inf, 1), complex(-zero, -zero)},
	{complex(-zero, -1), complex(inf, -1), complex(zero, -zero)},
	{complex(-zero, -1), complex(inf, 2), complex(-zero, -zero)},
	{complex(-zero, -1), complex(nan, nan), complex(nan, nan)},
	{complex(-zero, -1), complex(nan, inf), complex(-zero, zero)},
	{complex(-zero, -1), complex(nan, -inf), complex(zero, zero)},
	{complex(-zero, -1), complex(-inf, zero), complex(-zero, zero)},
	{complex(-zero, -1), complex(-inf, -zero), complex(zero, zero)},
	{complex(-zero, -1), complex(-inf, 1), complex(-zero, zero)},
	{complex(-zero, -1), complex(-inf, -1), complex(zero, zero)},
	{complex(-zero, -1), complex(-inf, 2), complex(-zero, zero)},
	{complex(-zero, -1), complex(nan, nan), complex(nan, nan)},
	{complex(-zero, -1), complex(nan, inf), complex(-zero, zero)},
	{complex(-zero, -1), complex(nan, -inf), complex(zero, zero)},
	{complex(zero, 2), complex(zero, zero), complex(nan, inf)},
	{complex(zero, 2), complex(zero, -zero), complex(nan, inf)},
	{complex(zero, 2), complex(zero, 1), complex(2, zero)},
	{complex(zero, 2), complex(zero, -1), complex(-2, zero)},
	{complex(zero, 2), complex(zero, 2), complex(1, zero)},
	{complex(zero, 2), complex(nan, nan), complex(nan, nan)},
	{complex(zero, 2), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, 2), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, 2), complex(zero, zero), complex(nan, inf)},
	{complex(zero, 2), complex(-zero, -zero), complex(nan, -inf)},
	{complex(zero, 2), complex(zero, 1), complex(2, zero)},
	{complex(zero, 2), complex(-zero, -1), complex(-2, -zero)},
	{complex(zero, 2), complex(zero, 2), complex(1, zero)},
	{complex(zero, 2), complex(nan, nan), complex(nan, nan)},
	{complex(zero, 2), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, 2), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, 2), complex(1, zero), complex(zero, 2)},
	{complex(zero, 2), complex(1, -zero), complex(zero, 2)},
	{complex(zero, 2), complex(1, 1), complex(1, 1)},
	{complex(zero, 2), complex(1, -1), complex(-1, 1)},
	{complex(zero, 2), complex(1, 2), complex(0.8, 0.4)},
	{complex(zero, 2), complex(nan, nan), complex(nan, nan)},
	{complex(zero, 2), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, 2), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, 2), complex(-1, zero), complex(-zero, -2)},
	{complex(zero, 2), complex(-1, -zero), complex(-zero, -2)},
	{complex(zero, 2), complex(-1, 1), complex(1, -1)},
	{complex(zero, 2), complex(-1, -1), complex(-1, -1)},
	{complex(zero, 2), complex(-1, 2), complex(0.8, -0.4)},
	{complex(zero, 2), complex(nan, nan), complex(nan, nan)},
	{complex(zero, 2), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, 2), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, 2), complex(2, zero), complex(zero, 1)},
	{complex(zero, 2), complex(2, -zero), complex(zero, 1)},
	{complex(zero, 2), complex(2, 1), complex(0.4, 0.8)},
	{complex(zero, 2), complex(2, -1), complex(-0.4, 0.8)},
	{complex(zero, 2), complex(2, 2), complex(0.5, 0.5)},
	{complex(zero, 2), complex(nan, nan), complex(nan, nan)},
	{complex(zero, 2), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, 2), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, 2), complex(nan, zero), complex(nan, nan)},
	{complex(zero, 2), complex(nan, -zero), complex(nan, nan)},
	{complex(zero, 2), complex(nan, 1), complex(nan, nan)},
	{complex(zero, 2), complex(nan, -1), complex(nan, nan)},
	{complex(zero, 2), complex(nan, 2), complex(nan, nan)},
	{complex(zero, 2), complex(nan, nan), complex(nan, nan)},
	{complex(zero, 2), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, 2), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, 2), complex(inf, zero), complex(zero, zero)},
	{complex(zero, 2), complex(inf, -zero), complex(zero, zero)},
	{complex(zero, 2), complex(inf, 1), complex(zero, zero)},
	{complex(zero, 2), complex(inf, -1), complex(zero, zero)},
	{complex(zero, 2), complex(inf, 2), complex(zero, zero)},
	{complex(zero, 2), complex(nan, nan), complex(nan, nan)},
	{complex(zero, 2), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, 2), complex(nan, -inf), complex(-zero, zero)},
	{complex(zero, 2), complex(-inf, zero), complex(-zero, -zero)},
	{complex(zero, 2), complex(-inf, -zero), complex(-zero, -zero)},
	{complex(zero, 2), complex(-inf, 1), complex(-zero, -zero)},
	{complex(zero, 2), complex(-inf, -1), complex(-zero, -zero)},
	{complex(zero, 2), complex(-inf, 2), complex(-zero, -zero)},
	{complex(zero, 2), complex(nan, nan), complex(nan, nan)},
	{complex(zero, 2), complex(nan, inf), complex(zero, -zero)},
	{complex(zero, 2), complex(nan, -inf), complex(-zero, zero)},
	{complex(nan, nan), complex(zero, zero), complex(nan, nan)},
	{complex(nan, nan), complex(zero, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(zero, 1), complex(nan, nan)},
	{complex(nan, nan), complex(zero, -1), complex(nan, nan)},
	{complex(nan, nan), complex(zero, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(zero, zero), complex(nan, nan)},
	{complex(nan, nan), complex(-zero, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(zero, 1), complex(nan, nan)},
	{complex(nan, nan), complex(-zero, -1), complex(nan, nan)},
	{complex(nan, nan), complex(zero, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(1, zero), complex(nan, nan)},
	{complex(nan, nan), complex(1, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(1, 1), complex(nan, nan)},
	{complex(nan, nan), complex(1, -1), complex(nan, nan)},
	{complex(nan, nan), complex(1, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(-1, zero), complex(nan, nan)},
	{complex(nan, nan), complex(-1, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(-1, 1), complex(nan, nan)},
	{complex(nan, nan), complex(-1, -1), complex(nan, nan)},
	{complex(nan, nan), complex(-1, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(2, zero), complex(nan, nan)},
	{complex(nan, nan), complex(2, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(2, 1), complex(nan, nan)},
	{complex(nan, nan), complex(2, -1), complex(nan, nan)},
	{complex(nan, nan), complex(2, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, zero), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(nan, 1), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -1), complex(nan, nan)},
	{complex(nan, nan), complex(nan, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(inf, zero), complex(nan, nan)},
	{complex(nan, nan), complex(inf, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(inf, 1), complex(nan, nan)},
	{complex(nan, nan), complex(inf, -1), complex(nan, nan)},
	{complex(nan, nan), complex(inf, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, zero), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, 1), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, -1), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(zero, zero), complex(nan, inf)},
	{complex(nan, inf), complex(zero, -zero), complex(nan, inf)},
	{complex(nan, inf), complex(zero, 1), complex(inf, nan)},
	{complex(nan, inf), complex(zero, -1), complex(-inf, nan)},
	{complex(nan, inf), complex(zero, 2), complex(inf, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(zero, zero), complex(nan, inf)},
	{complex(nan, inf), complex(-zero, -zero), complex(nan, -inf)},
	{complex(nan, inf), complex(zero, 1), complex(inf, nan)},
	{complex(nan, inf), complex(-zero, -1), complex(-inf, nan)},
	{complex(nan, inf), complex(zero, 2), complex(inf, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(1, zero), complex(nan, inf)},
	{complex(nan, inf), complex(1, -zero), complex(nan, inf)},
	{complex(nan, inf), complex(1, 1), complex(inf, inf)},
	{complex(nan, inf), complex(1, -1), complex(-inf, inf)},
	{complex(nan, inf), complex(1, 2), complex(inf, inf)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(-1, zero), complex(nan, -inf)},
	{complex(nan, inf), complex(-1, -zero), complex(nan, -inf)},
	{complex(nan, inf), complex(-1, 1), complex(inf, -inf)},
	{complex(nan, inf), complex(-1, -1), complex(-inf, -inf)},
	{complex(nan, inf), complex(-1, 2), complex(inf, -inf)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(2, zero), complex(nan, inf)},
	{complex(nan, inf), complex(2, -zero), complex(nan, inf)},
	{complex(nan, inf), complex(2, 1), complex(inf, inf)},
	{complex(nan, inf), complex(2, -1), complex(-inf, inf)},
	{complex(nan, inf), complex(2, 2), complex(inf, inf)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, zero), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -zero), complex(nan, nan)},
	{complex(nan, inf), complex(nan, 1), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -1), complex(nan, nan)},
	{complex(nan, inf), complex(nan, 2), complex(nan, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(inf, zero), complex(nan, nan)},
	{complex(nan, inf), complex(inf, -zero), complex(nan, nan)},
	{complex(nan, inf), complex(inf, 1), complex(nan, nan)},
	{complex(nan, inf), complex(inf, -1), complex(nan, nan)},
	{complex(nan, inf), complex(inf, 2), complex(nan, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, zero), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, -zero), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, 1), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, -1), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, 2), complex(nan, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(zero, zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(zero, -zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(zero, 1), complex(-inf, nan)},
	{complex(nan, -inf), complex(zero, -1), complex(inf, nan)},
	{complex(nan, -inf), complex(zero, 2), complex(-inf, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(zero, zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(-zero, -zero), complex(nan, inf)},
	{complex(nan, -inf), complex(zero, 1), complex(-inf, nan)},
	{complex(nan, -inf), complex(-zero, -1), complex(inf, nan)},
	{complex(nan, -inf), complex(zero, 2), complex(-inf, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(1, zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(1, -zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(1, 1), complex(-inf, -inf)},
	{complex(nan, -inf), complex(1, -1), complex(inf, -inf)},
	{complex(nan, -inf), complex(1, 2), complex(-inf, -inf)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(-1, zero), complex(nan, inf)},
	{complex(nan, -inf), complex(-1, -zero), complex(nan, inf)},
	{complex(nan, -inf), complex(-1, 1), complex(-inf, inf)},
	{complex(nan, -inf), complex(-1, -1), complex(inf, inf)},
	{complex(nan, -inf), complex(-1, 2), complex(-inf, inf)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(2, zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(2, -zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(2, 1), complex(-inf, -inf)},
	{complex(nan, -inf), complex(2, -1), complex(inf, -inf)},
	{complex(nan, -inf), complex(2, 2), complex(-inf, -inf)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, zero), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -zero), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, 1), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -1), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, 2), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, zero), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, -zero), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, 1), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, -1), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, 2), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, zero), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, -zero), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, 1), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, -1), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, 2), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(1, zero), complex(zero, zero), complex(inf, nan)},
	{complex(1, zero), complex(zero, -zero), complex(inf, nan)},
	{complex(1, zero), complex(zero, 1), complex(zero, -1)},
	{complex(1, zero), complex(zero, -1), complex(-zero, 1)},
	{complex(1, zero), complex(zero, 2), complex(zero, -0.5)},
	{complex(1, zero), complex(nan, nan), complex(nan, nan)},
	{complex(1, zero), complex(nan, inf), complex(zero, -zero)},
	{complex(1, zero), complex(nan, -inf), complex(-zero, zero)},
	{complex(1, zero), complex(zero, zero), complex(inf, nan)},
	{complex(1, zero), complex(-zero, -zero), complex(-inf, nan)},
	{complex(1, zero), complex(zero, 1), complex(zero, -1)},
	{complex(1, zero), complex(-zero, -1), complex(-zero, 1)},
	{complex(1, zero), complex(zero, 2), complex(zero, -0.5)},
	{complex(1, zero), complex(nan, nan), complex(nan, nan)},
	{complex(1, zero), complex(nan, inf), complex(zero, -zero)},
	{complex(1, zero), complex(nan, -inf), complex(-zero, zero)},
	{complex(1, zero), complex(1, zero), complex(1, zero)},
	{complex(1, zero), complex(1, -zero), complex(1, zero)},
	{complex(1, zero), complex(1, 1), complex(0.5, -0.5)},
	{complex(1, zero), complex(1, -1), complex(0.5, 0.5)},
	{complex(1, zero), complex(1, 2), complex(0.2, -0.4)},
	{complex(1, zero), complex(nan, nan), complex(nan, nan)},
	{complex(1, zero), complex(nan, inf), complex(zero, -zero)},
	{complex(1, zero), complex(nan, -inf), complex(-zero, zero)},
	{complex(1, zero), complex(-1, zero), complex(-1, -zero)},
	{complex(1, zero), complex(-1, -zero), complex(-1, -zero)},
	{complex(1, zero), complex(-1, 1), complex(-0.5, -0.5)},
	{complex(1, zero), complex(-1, -1), complex(-0.5, 0.5)},
	{complex(1, zero), complex(-1, 2), complex(-0.2, -0.4)},
	{complex(1, zero), complex(nan, nan), complex(nan, nan)},
	{complex(1, zero), complex(nan, inf), complex(zero, -zero)},
	{complex(1, zero), complex(nan, -inf), complex(-zero, zero)},
	{complex(1, zero), complex(2, zero), complex(0.5, zero)},
	{complex(1, zero), complex(2, -zero), complex(0.5, zero)},
	{complex(1, zero), complex(2, 1), complex(0.4, -0.2)},
	{complex(1, zero), complex(2, -1), complex(0.4, 0.2)},
	{complex(1, zero), complex(2, 2), complex(0.25, -0.25)},
	{complex(1, zero), complex(nan, nan), complex(nan, nan)},
	{complex(1, zero), complex(nan, inf), complex(zero, -zero)},
	{complex(1, zero), complex(nan, -inf), complex(-zero, zero)},
	{complex(1, zero), complex(nan, zero), complex(nan, nan)},
	{complex(1, zero), complex(nan, -zero), complex(nan, nan)},
	{complex(1, zero), complex(nan, 1), complex(nan, nan)},
	{complex(1, zero), complex(nan, -1), complex(nan, nan)},
	{complex(1, zero), complex(nan, 2), complex(nan, nan)},
	{complex(1, zero), complex(nan, nan), complex(nan, nan)},
	{complex(1, zero), complex(nan, inf), complex(zero, -zero)},
	{complex(1, zero), complex(nan, -inf), complex(-zero, zero)},
	{complex(1, zero), complex(inf, zero), complex(zero, zero)},
	{complex(1, zero), complex(inf, -zero), complex(zero, zero)},
	{complex(1, zero), complex(inf, 1), complex(zero, zero)},
	{complex(1, zero), complex(inf, -1), complex(zero, zero)},
	{complex(1, zero), complex(inf, 2), complex(zero, zero)},
	{complex(1, zero), complex(nan, nan), complex(nan, nan)},
	{complex(1, zero), complex(nan, inf), complex(zero, -zero)},
	{complex(1, zero), complex(nan, -inf), complex(-zero, zero)},
	{complex(1, zero), complex(-inf, zero), complex(-zero, -zero)},
	{complex(1, zero), complex(-inf, -zero), complex(-zero, -zero)},
	{complex(1, zero), complex(-inf, 1), complex(-zero, -zero)},
	{complex(1, zero), complex(-inf, -1), complex(-zero, -zero)},
	{complex(1, zero), complex(-inf, 2), complex(-zero, -zero)},
	{complex(1, zero), complex(nan, nan), complex(nan, nan)},
	{complex(1, zero), complex(nan, inf), complex(zero, -zero)},
	{complex(1, zero), complex(nan, -inf), complex(-zero, zero)},
	{complex(1, -zero), complex(zero, zero), complex(inf, nan)},
	{complex(1, -zero), complex(zero, -zero), complex(inf, nan)},
	{complex(1, -zero), complex(zero, 1), complex(zero, -1)},
	{complex(1, -zero), complex(zero, -1), complex(zero, 1)},
	{complex(1, -zero), complex(zero, 2), complex(zero, -0.5)},
	{complex(1, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(1, -zero), complex(nan, inf), complex(-zero, -zero)},
	{complex(1, -zero), complex(nan, -inf), complex(zero, zero)},
	{complex(1, -zero), complex(zero, zero), complex(inf, nan)},
	{complex(1, -zero), complex(-zero, -zero), complex(-inf, nan)},
	{complex(1, -zero), complex(zero, 1), complex(zero, -1)},
	{complex(1, -zero), complex(-zero, -1), complex(-zero, 1)},
	{complex(1, -zero), complex(zero, 2), complex(zero, -0.5)},
	{complex(1, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(1, -zero), complex(nan, inf), complex(-zero, -zero)},
	{complex(1, -zero), complex(nan, -inf), complex(zero, zero)},
	{complex(1, -zero), complex(1, zero), complex(1, -zero)},
	{complex(1, -zero), complex(1, -zero), complex(1, zero)},
	{complex(1, -zero), complex(1, 1), complex(0.5, -0.5)},
	{complex(1, -zero), complex(1, -1), complex(0.5, 0.5)},
	{complex(1, -zero), complex(1, 2), complex(0.2, -0.4)},
	{complex(1, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(1, -zero), complex(nan, inf), complex(-zero, -zero)},
	{complex(1, -zero), complex(nan, -inf), complex(zero, zero)},
	{complex(1, -zero), complex(-1, zero), complex(-1, -zero)},
	{complex(1, -zero), complex(-1, -zero), complex(-1, zero)},
	{complex(1, -zero), complex(-1, 1), complex(-0.5, -0.5)},
	{complex(1, -zero), complex(-1, -1), complex(-0.5, 0.5)},
	{complex(1, -zero), complex(-1, 2), complex(-0.2, -0.4)},
	{complex(1, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(1, -zero), complex(nan, inf), complex(-zero, -zero)},
	{complex(1, -zero), complex(nan, -inf), complex(zero, zero)},
	{complex(1, -zero), complex(2, zero), complex(0.5, -zero)},
	{complex(1, -zero), complex(2, -zero), complex(0.5, zero)},
	{complex(1, -zero), complex(2, 1), complex(0.4, -0.2)},
	{complex(1, -zero), complex(2, -1), complex(0.4, 0.2)},
	{complex(1, -zero), complex(2, 2), complex(0.25, -0.25)},
	{complex(1, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(1, -zero), complex(nan, inf), complex(-zero, -zero)},
	{complex(1, -zero), complex(nan, -inf), complex(zero, zero)},
	{complex(1, -zero), complex(nan, zero), complex(nan, nan)},
	{complex(1, -zero), complex(nan, -zero), complex(nan, nan)},
	{complex(1, -zero), complex(nan, 1), complex(nan, nan)},
	{complex(1, -zero), complex(nan, -1), complex(nan, nan)},
	{complex(1, -zero), complex(nan, 2), complex(nan, nan)},
	{complex(1, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(1, -zero), complex(nan, inf), complex(-zero, -zero)},
	{complex(1, -zero), complex(nan, -inf), complex(zero, zero)},
	{complex(1, -zero), complex(inf, zero), complex(zero, -zero)},
	{complex(1, -zero), complex(inf, -zero), complex(zero, zero)},
	{complex(1, -zero), complex(inf, 1), complex(zero, -zero)},
	{complex(1, -zero), complex(inf, -1), complex(zero, zero)},
	{complex(1, -zero), complex(inf, 2), complex(zero, -zero)},
	{complex(1, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(1, -zero), complex(nan, inf), complex(-zero, -zero)},
	{complex(1, -zero), complex(nan, -inf), complex(zero, zero)},
	{complex(1, -zero), complex(-inf, zero), complex(-zero, -zero)},
	{complex(1, -zero), complex(-inf, -zero), complex(-zero, zero)},
	{complex(1, -zero), complex(-inf, 1), complex(-zero, -zero)},
	{complex(1, -zero), complex(-inf, -1), complex(-zero, zero)},
	{complex(1, -zero), complex(-inf, 2), complex(-zero, -zero)},
	{complex(1, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(1, -zero), complex(nan, inf), complex(-zero, -zero)},
	{complex(1, -zero), complex(nan, -inf), complex(zero, zero)},
	{complex(1, 1), complex(zero, zero), complex(inf, inf)},
	{complex(1, 1), complex(zero, -zero), complex(inf, inf)},
	{complex(1, 1), complex(zero, 1), complex(1, -1)},
	{complex(1, 1), complex(zero, -1), complex(-1, 1)},
	{complex(1, 1), complex(zero, 2), complex(0.5, -0.5)},
	{complex(1, 1), complex(nan, nan), complex(nan, nan)},
	{complex(1, 1), complex(nan, inf), complex(zero, -zero)},
	{complex(1, 1), complex(nan, -inf), complex(-zero, zero)},
	{complex(1, 1), complex(zero, zero), complex(inf, inf)},
	{complex(1, 1), complex(-zero, -zero), complex(-inf, -inf)},
	{complex(1, 1), complex(zero, 1), complex(1, -1)},
	{complex(1, 1), complex(-zero, -1), complex(-1, 1)},
	{complex(1, 1), complex(zero, 2), complex(0.5, -0.5)},
	{complex(1, 1), complex(nan, nan), complex(nan, nan)},
	{complex(1, 1), complex(nan, inf), complex(zero, -zero)},
	{complex(1, 1), complex(nan, -inf), complex(-zero, zero)},
	{complex(1, 1), complex(1, zero), complex(1, 1)},
	{complex(1, 1), complex(1, -zero), complex(1, 1)},
	{complex(1, 1), complex(1, 1), complex(1, zero)},
	{complex(1, 1), complex(1, -1), complex(zero, 1)},
	{complex(1, 1), complex(1, 2), complex(0.6, -0.2)},
	{complex(1, 1), complex(nan, nan), complex(nan, nan)},
	{complex(1, 1), complex(nan, inf), complex(zero, -zero)},
	{complex(1, 1), complex(nan, -inf), complex(-zero, zero)},
	{complex(1, 1), complex(-1, zero), complex(-1, -1)},
	{complex(1, 1), complex(-1, -zero), complex(-1, -1)},
	{complex(1, 1), complex(-1, 1), complex(-zero, -1)},
	{complex(1, 1), complex(-1, -1), complex(-1, -zero)},
	{complex(1, 1), complex(-1, 2), complex(0.2, -0.6)},
	{complex(1, 1), complex(nan, nan), complex(nan, nan)},
	{complex(1, 1), complex(nan, inf), complex(zero, -zero)},
	{complex(1, 1), complex(nan, -inf), complex(-zero, zero)},
	{complex(1, 1), complex(2, zero), complex(0.5, 0.5)},
	{complex(1, 1), complex(2, -zero), complex(0.5, 0.5)},
	{complex(1, 1), complex(2, 1), complex(0.6, 0.2)},
	{complex(1, 1), complex(2, -1), complex(0.2, 0.6)},
	{complex(1, 1), complex(2, 2), complex(0.5, zero)},
	{complex(1, 1), complex(nan, nan), complex(nan, nan)},
	{complex(1, 1), complex(nan, inf), complex(zero, -zero)},
	{complex(1, 1), complex(nan, -inf), complex(-zero, zero)},
	{complex(1, 1), complex(nan, zero), complex(nan, nan)},
	{complex(1, 1), complex(nan, -zero), complex(nan, nan)},
	{complex(1, 1), complex(nan, 1), complex(nan, nan)},
	{complex(1, 1), complex(nan, -1), complex(nan, nan)},
	{complex(1, 1), complex(nan, 2), complex(nan, nan)},
	{complex(1, 1), complex(nan, nan), complex(nan, nan)},
	{complex(1, 1), complex(nan, inf), complex(zero, -zero)},
	{complex(1, 1), complex(nan, -inf), complex(-zero, zero)},
	{complex(1, 1), complex(inf, zero), complex(zero, zero)},
	{complex(1, 1), complex(inf, -zero), complex(zero, zero)},
	{complex(1, 1), complex(inf, 1), complex(zero, zero)},
	{complex(1, 1), complex(inf, -1), complex(zero, zero)},
	{complex(1, 1), complex(inf, 2), complex(zero, zero)},
	{complex(1, 1), complex(nan, nan), complex(nan, nan)},
	{complex(1, 1), complex(nan, inf), complex(zero, -zero)},
	{complex(1, 1), complex(nan, -inf), complex(-zero, zero)},
	{complex(1, 1), complex(-inf, zero), complex(-zero, -zero)},
	{complex(1, 1), complex(-inf, -zero), complex(-zero, -zero)},
	{complex(1, 1), complex(-inf, 1), complex(-zero, -zero)},
	{complex(1, 1), complex(-inf, -1), complex(-zero, -zero)},
	{complex(1, 1), complex(-inf, 2), complex(-zero, -zero)},
	{complex(1, 1), complex(nan, nan), complex(nan, nan)},
	{complex(1, 1), complex(nan, inf), complex(zero, -zero)},
	{complex(1, 1), complex(nan, -inf), complex(-zero, zero)},
	{complex(1, -1), complex(zero, zero), complex(inf, -inf)},
	{complex(1, -1), complex(zero, -zero), complex(inf, -inf)},
	{complex(1, -1), complex(zero, 1), complex(-1, -1)},
	{complex(1, -1), complex(zero, -1), complex(1, 1)},
	{complex(1, -1), complex(zero, 2), complex(-0.5, -0.5)},
	{complex(1, -1), complex(nan, nan), complex(nan, nan)},
	{complex(1, -1), complex(nan, inf), complex(-zero, -zero)},
	{complex(1, -1), complex(nan, -inf), complex(zero, zero)},
	{complex(1, -1), complex(zero, zero), complex(inf, -inf)},
	{complex(1, -1), complex(-zero, -zero), complex(-inf, inf)},
	{complex(1, -1), complex(zero, 1), complex(-1, -1)},
	{complex(1, -1), complex(-zero, -1), complex(1, 1)},
	{complex(1, -1), complex(zero, 2), complex(-0.5, -0.5)},
	{complex(1, -1), complex(nan, nan), complex(nan, nan)},
	{complex(1, -1), complex(nan, inf), complex(-zero, -zero)},
	{complex(1, -1), complex(nan, -inf), complex(zero, zero)},
	{complex(1, -1), complex(1, zero), complex(1, -1)},
	{complex(1, -1), complex(1, -zero), complex(1, -1)},
	{complex(1, -1), complex(1, 1), complex(zero, -1)},
	{complex(1, -1), complex(1, -1), complex(1, zero)},
	{complex(1, -1), complex(1, 2), complex(-0.2, -0.6)},
	{complex(1, -1), complex(nan, nan), complex(nan, nan)},
	{complex(1, -1), complex(nan, inf), complex(-zero, -zero)},
	{complex(1, -1), complex(nan, -inf), complex(zero, zero)},
	{complex(1, -1), complex(-1, zero), complex(-1, 1)},
	{complex(1, -1), complex(-1, -zero), complex(-1, 1)},
	{complex(1, -1), complex(-1, 1), complex(-1, -zero)},
	{complex(1, -1), complex(-1, -1), complex(-zero, 1)},
	{complex(1, -1), complex(-1, 2), complex(-0.6, -0.2)},
	{complex(1, -1), complex(nan, nan), complex(nan, nan)},
	{complex(1, -1), complex(nan, inf), complex(-zero, -zero)},
	{complex(1, -1), complex(nan, -inf), complex(zero, zero)},
	{complex(1, -1), complex(2, zero), complex(0.5, -0.5)},
	{complex(1, -1), complex(2, -zero), complex(0.5, -0.5)},
	{complex(1, -1), complex(2, 1), complex(0.2, -0.6)},
	{complex(1, -1), complex(2, -1), complex(0.6, -0.2)},
	{complex(1, -1), complex(2, 2), complex(zero, -0.5)},
	{complex(1, -1), complex(nan, nan), complex(nan, nan)},
	{complex(1, -1), complex(nan, inf), complex(-zero, -zero)},
	{complex(1, -1), complex(nan, -inf), complex(zero, zero)},
	{complex(1, -1), complex(nan, zero), complex(nan, nan)},
	{complex(1, -1), complex(nan, -zero), complex(nan, nan)},
	{complex(1, -1), complex(nan, 1), complex(nan, nan)},
	{complex(1, -1), complex(nan, -1), complex(nan, nan)},
	{complex(1, -1), complex(nan, 2), complex(nan, nan)},
	{complex(1, -1), complex(nan, nan), complex(nan, nan)},
	{complex(1, -1), complex(nan, inf), complex(-zero, -zero)},
	{complex(1, -1), complex(nan, -inf), complex(zero, zero)},
	{complex(1, -1), complex(inf, zero), complex(zero, -zero)},
	{complex(1, -1), complex(inf, -zero), complex(zero, -zero)},
	{complex(1, -1), complex(inf, 1), complex(zero, -zero)},
	{complex(1, -1), complex(inf, -1), complex(zero, -zero)},
	{complex(1, -1), complex(inf, 2), complex(zero, -zero)},
	{complex(1, -1), complex(nan, nan), complex(nan, nan)},
	{complex(1, -1), complex(nan, inf), complex(-zero, -zero)},
	{complex(1, -1), complex(nan, -inf), complex(zero, zero)},
	{complex(1, -1), complex(-inf, zero), complex(-zero, zero)},
	{complex(1, -1), complex(-inf, -zero), complex(-zero, zero)},
	{complex(1, -1), complex(-inf, 1), complex(-zero, zero)},
	{complex(1, -1), complex(-inf, -1), complex(-zero, zero)},
	{complex(1, -1), complex(-inf, 2), complex(-zero, zero)},
	{complex(1, -1), complex(nan, nan), complex(nan, nan)},
	{complex(1, -1), complex(nan, inf), complex(-zero, -zero)},
	{complex(1, -1), complex(nan, -inf), complex(zero, zero)},
	{complex(1, 2), complex(zero, zero), complex(inf, inf)},
	{complex(1, 2), complex(zero, -zero), complex(inf, inf)},
	{complex(1, 2), complex(zero, 1), complex(2, -1)},
	{complex(1, 2), complex(zero, -1), complex(-2, 1)},
	{complex(1, 2), complex(zero, 2), complex(1, -0.5)},
	{complex(1, 2), complex(nan, nan), complex(nan, nan)},
	{complex(1, 2), complex(nan, inf), complex(zero, -zero)},
	{complex(1, 2), complex(nan, -inf), complex(-zero, zero)},
	{complex(1, 2), complex(zero, zero), complex(inf, inf)},
	{complex(1, 2), complex(-zero, -zero), complex(-inf, -inf)},
	{complex(1, 2), complex(zero, 1), complex(2, -1)},
	{complex(1, 2), complex(-zero, -1), complex(-2, 1)},
	{complex(1, 2), complex(zero, 2), complex(1, -0.5)},
	{complex(1, 2), complex(nan, nan), complex(nan, nan)},
	{complex(1, 2), complex(nan, inf), complex(zero, -zero)},
	{complex(1, 2), complex(nan, -inf), complex(-zero, zero)},
	{complex(1, 2), complex(1, zero), complex(1, 2)},
	{complex(1, 2), complex(1, -zero), complex(1, 2)},
	{complex(1, 2), complex(1, 1), complex(1.5, 0.5)},
	{complex(1, 2), complex(1, -1), complex(-0.5, 1.5)},
	{complex(1, 2), complex(1, 2), complex(1, zero)},
	{complex(1, 2), complex(nan, nan), complex(nan, nan)},
	{complex(1, 2), complex(nan, inf), complex(zero, -zero)},
	{complex(1, 2), complex(nan, -inf), complex(-zero, zero)},
	{complex(1, 2), complex(-1, zero), complex(-1, -2)},
	{complex(1, 2), complex(-1, -zero), complex(-1, -2)},
	{complex(1, 2), complex(-1, 1), complex(0.5, -1.5)},
	{complex(1, 2), complex(-1, -1), complex(-1.5, -0.5)},
	{complex(1, 2), complex(-1, 2), complex(0.6, -0.8)},
	{complex(1, 2), complex(nan, nan), complex(nan, nan)},
	{complex(1, 2), complex(nan, inf), complex(zero, -zero)},
	{complex(1, 2), complex(nan, -inf), complex(-zero, zero)},
	{complex(1, 2), complex(2, zero), complex(0.5, 1)},
	{complex(1, 2), complex(2, -zero), complex(0.5, 1)},
	{complex(1, 2), complex(2, 1), complex(0.8, 0.6)},
	{complex(1, 2), complex(2, -1), complex(zero, 1)},
	{complex(1, 2), complex(2, 2), complex(0.75, 0.25)},
	{complex(1, 2), complex(nan, nan), complex(nan, nan)},
	{complex(1, 2), complex(nan, inf), complex(zero, -zero)},
	{complex(1, 2), complex(nan, -inf), complex(-zero, zero)},
	{complex(1, 2), complex(nan, zero), complex(nan, nan)},
	{complex(1, 2), complex(nan, -zero), complex(nan, nan)},
	{complex(1, 2), complex(nan, 1), complex(nan, nan)},
	{complex(1, 2), complex(nan, -1), complex(nan, nan)},
	{complex(1, 2), complex(nan, 2), complex(nan, nan)},
	{complex(1, 2), complex(nan, nan), complex(nan, nan)},
	{complex(1, 2), complex(nan, inf), complex(zero, -zero)},
	{complex(1, 2), complex(nan, -inf), complex(-zero, zero)},
	{complex(1, 2), complex(inf, zero), complex(zero, zero)},
	{complex(1, 2), complex(inf, -zero), complex(zero, zero)},
	{complex(1, 2), complex(inf, 1), complex(zero, zero)},
	{complex(1, 2), complex(inf, -1), complex(zero, zero)},
	{complex(1, 2), complex(inf, 2), complex(zero, zero)},
	{complex(1, 2), complex(nan, nan), complex(nan, nan)},
	{complex(1, 2), complex(nan, inf), complex(zero, -zero)},
	{complex(1, 2), complex(nan, -inf), complex(-zero, zero)},
	{complex(1, 2), complex(-inf, zero), complex(-zero, -zero)},
	{complex(1, 2), complex(-inf, -zero), complex(-zero, -zero)},
	{complex(1, 2), complex(-inf, 1), complex(-zero, -zero)},
	{complex(1, 2), complex(-inf, -1), complex(-zero, -zero)},
	{complex(1, 2), complex(-inf, 2), complex(-zero, -zero)},
	{complex(1, 2), complex(nan, nan), complex(nan, nan)},
	{complex(1, 2), complex(nan, inf), complex(zero, -zero)},
	{complex(1, 2), complex(nan, -inf), complex(-zero, zero)},
	{complex(nan, nan), complex(zero, zero), complex(nan, nan)},
	{complex(nan, nan), complex(zero, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(zero, 1), complex(nan, nan)},
	{complex(nan, nan), complex(zero, -1), complex(nan, nan)},
	{complex(nan, nan), complex(zero, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(zero, zero), complex(nan, nan)},
	{complex(nan, nan), complex(-zero, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(zero, 1), complex(nan, nan)},
	{complex(nan, nan), complex(-zero, -1), complex(nan, nan)},
	{complex(nan, nan), complex(zero, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(1, zero), complex(nan, nan)},
	{complex(nan, nan), complex(1, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(1, 1), complex(nan, nan)},
	{complex(nan, nan), complex(1, -1), complex(nan, nan)},
	{complex(nan, nan), complex(1, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(-1, zero), complex(nan, nan)},
	{complex(nan, nan), complex(-1, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(-1, 1), complex(nan, nan)},
	{complex(nan, nan), complex(-1, -1), complex(nan, nan)},
	{complex(nan, nan), complex(-1, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(2, zero), complex(nan, nan)},
	{complex(nan, nan), complex(2, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(2, 1), complex(nan, nan)},
	{complex(nan, nan), complex(2, -1), complex(nan, nan)},
	{complex(nan, nan), complex(2, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, zero), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(nan, 1), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -1), complex(nan, nan)},
	{complex(nan, nan), complex(nan, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(inf, zero), complex(nan, nan)},
	{complex(nan, nan), complex(inf, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(inf, 1), complex(nan, nan)},
	{complex(nan, nan), complex(inf, -1), complex(nan, nan)},
	{complex(nan, nan), complex(inf, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, zero), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, 1), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, -1), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(zero, zero), complex(nan, inf)},
	{complex(nan, inf), complex(zero, -zero), complex(nan, inf)},
	{complex(nan, inf), complex(zero, 1), complex(inf, nan)},
	{complex(nan, inf), complex(zero, -1), complex(-inf, nan)},
	{complex(nan, inf), complex(zero, 2), complex(inf, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(zero, zero), complex(nan, inf)},
	{complex(nan, inf), complex(-zero, -zero), complex(nan, -inf)},
	{complex(nan, inf), complex(zero, 1), complex(inf, nan)},
	{complex(nan, inf), complex(-zero, -1), complex(-inf, nan)},
	{complex(nan, inf), complex(zero, 2), complex(inf, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(1, zero), complex(nan, inf)},
	{complex(nan, inf), complex(1, -zero), complex(nan, inf)},
	{complex(nan, inf), complex(1, 1), complex(inf, inf)},
	{complex(nan, inf), complex(1, -1), complex(-inf, inf)},
	{complex(nan, inf), complex(1, 2), complex(inf, inf)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(-1, zero), complex(nan, -inf)},
	{complex(nan, inf), complex(-1, -zero), complex(nan, -inf)},
	{complex(nan, inf), complex(-1, 1), complex(inf, -inf)},
	{complex(nan, inf), complex(-1, -1), complex(-inf, -inf)},
	{complex(nan, inf), complex(-1, 2), complex(inf, -inf)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(2, zero), complex(nan, inf)},
	{complex(nan, inf), complex(2, -zero), complex(nan, inf)},
	{complex(nan, inf), complex(2, 1), complex(inf, inf)},
	{complex(nan, inf), complex(2, -1), complex(-inf, inf)},
	{complex(nan, inf), complex(2, 2), complex(inf, inf)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, zero), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -zero), complex(nan, nan)},
	{complex(nan, inf), complex(nan, 1), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -1), complex(nan, nan)},
	{complex(nan, inf), complex(nan, 2), complex(nan, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(inf, zero), complex(nan, nan)},
	{complex(nan, inf), complex(inf, -zero), complex(nan, nan)},
	{complex(nan, inf), complex(inf, 1), complex(nan, nan)},
	{complex(nan, inf), complex(inf, -1), complex(nan, nan)},
	{complex(nan, inf), complex(inf, 2), complex(nan, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, zero), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, -zero), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, 1), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, -1), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, 2), complex(nan, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(zero, zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(zero, -zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(zero, 1), complex(-inf, nan)},
	{complex(nan, -inf), complex(zero, -1), complex(inf, nan)},
	{complex(nan, -inf), complex(zero, 2), complex(-inf, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(zero, zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(-zero, -zero), complex(nan, inf)},
	{complex(nan, -inf), complex(zero, 1), complex(-inf, nan)},
	{complex(nan, -inf), complex(-zero, -1), complex(inf, nan)},
	{complex(nan, -inf), complex(zero, 2), complex(-inf, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(1, zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(1, -zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(1, 1), complex(-inf, -inf)},
	{complex(nan, -inf), complex(1, -1), complex(inf, -inf)},
	{complex(nan, -inf), complex(1, 2), complex(-inf, -inf)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(-1, zero), complex(nan, inf)},
	{complex(nan, -inf), complex(-1, -zero), complex(nan, inf)},
	{complex(nan, -inf), complex(-1, 1), complex(-inf, inf)},
	{complex(nan, -inf), complex(-1, -1), complex(inf, inf)},
	{complex(nan, -inf), complex(-1, 2), complex(-inf, inf)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(2, zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(2, -zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(2, 1), complex(-inf, -inf)},
	{complex(nan, -inf), complex(2, -1), complex(inf, -inf)},
	{complex(nan, -inf), complex(2, 2), complex(-inf, -inf)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, zero), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -zero), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, 1), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -1), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, 2), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, zero), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, -zero), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, 1), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, -1), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, 2), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, zero), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, -zero), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, 1), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, -1), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, 2), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(-1, zero), complex(zero, zero), complex(-inf, nan)},
	{complex(-1, zero), complex(zero, -zero), complex(-inf, nan)},
	{complex(-1, zero), complex(zero, 1), complex(zero, 1)},
	{complex(-1, zero), complex(zero, -1), complex(-zero, -1)},
	{complex(-1, zero), complex(zero, 2), complex(zero, 0.5)},
	{complex(-1, zero), complex(nan, nan), complex(nan, nan)},
	{complex(-1, zero), complex(nan, inf), complex(zero, zero)},
	{complex(-1, zero), complex(nan, -inf), complex(zero, -zero)},
	{complex(-1, zero), complex(zero, zero), complex(-inf, nan)},
	{complex(-1, zero), complex(-zero, -zero), complex(inf, nan)},
	{complex(-1, zero), complex(zero, 1), complex(zero, 1)},
	{complex(-1, zero), complex(-zero, -1), complex(-zero, -1)},
	{complex(-1, zero), complex(zero, 2), complex(zero, 0.5)},
	{complex(-1, zero), complex(nan, nan), complex(nan, nan)},
	{complex(-1, zero), complex(nan, inf), complex(zero, zero)},
	{complex(-1, zero), complex(nan, -inf), complex(zero, -zero)},
	{complex(-1, zero), complex(1, zero), complex(-1, zero)},
	{complex(-1, zero), complex(1, -zero), complex(-1, zero)},
	{complex(-1, zero), complex(1, 1), complex(-0.5, 0.5)},
	{complex(-1, zero), complex(1, -1), complex(-0.5, -0.5)},
	{complex(-1, zero), complex(1, 2), complex(-0.2, 0.4)},
	{complex(-1, zero), complex(nan, nan), complex(nan, nan)},
	{complex(-1, zero), complex(nan, inf), complex(zero, zero)},
	{complex(-1, zero), complex(nan, -inf), complex(zero, -zero)},
	{complex(-1, zero), complex(-1, zero), complex(1, -zero)},
	{complex(-1, zero), complex(-1, -zero), complex(1, -zero)},
	{complex(-1, zero), complex(-1, 1), complex(0.5, 0.5)},
	{complex(-1, zero), complex(-1, -1), complex(0.5, -0.5)},
	{complex(-1, zero), complex(-1, 2), complex(0.2, 0.4)},
	{complex(-1, zero), complex(nan, nan), complex(nan, nan)},
	{complex(-1, zero), complex(nan, inf), complex(zero, zero)},
	{complex(-1, zero), complex(nan, -inf), complex(zero, -zero)},
	{complex(-1, zero), complex(2, zero), complex(-0.5, zero)},
	{complex(-1, zero), complex(2, -zero), complex(-0.5, zero)},
	{complex(-1, zero), complex(2, 1), complex(-0.4, 0.2)},
	{complex(-1, zero), complex(2, -1), complex(-0.4, -0.2)},
	{complex(-1, zero), complex(2, 2), complex(-0.25, 0.25)},
	{complex(-1, zero), complex(nan, nan), complex(nan, nan)},
	{complex(-1, zero), complex(nan, inf), complex(zero, zero)},
	{complex(-1, zero), complex(nan, -inf), complex(zero, -zero)},
	{complex(-1, zero), complex(nan, zero), complex(nan, nan)},
	{complex(-1, zero), complex(nan, -zero), complex(nan, nan)},
	{complex(-1, zero), complex(nan, 1), complex(nan, nan)},
	{complex(-1, zero), complex(nan, -1), complex(nan, nan)},
	{complex(-1, zero), complex(nan, 2), complex(nan, nan)},
	{complex(-1, zero), complex(nan, nan), complex(nan, nan)},
	{complex(-1, zero), complex(nan, inf), complex(zero, zero)},
	{complex(-1, zero), complex(nan, -inf), complex(zero, -zero)},
	{complex(-1, zero), complex(inf, zero), complex(-zero, zero)},
	{complex(-1, zero), complex(inf, -zero), complex(-zero, zero)},
	{complex(-1, zero), complex(inf, 1), complex(-zero, zero)},
	{complex(-1, zero), complex(inf, -1), complex(-zero, zero)},
	{complex(-1, zero), complex(inf, 2), complex(-zero, zero)},
	{complex(-1, zero), complex(nan, nan), complex(nan, nan)},
	{complex(-1, zero), complex(nan, inf), complex(zero, zero)},
	{complex(-1, zero), complex(nan, -inf), complex(zero, -zero)},
	{complex(-1, zero), complex(-inf, zero), complex(zero, -zero)},
	{complex(-1, zero), complex(-inf, -zero), complex(zero, -zero)},
	{complex(-1, zero), complex(-inf, 1), complex(zero, -zero)},
	{complex(-1, zero), complex(-inf, -1), complex(zero, -zero)},
	{complex(-1, zero), complex(-inf, 2), complex(zero, -zero)},
	{complex(-1, zero), complex(nan, nan), complex(nan, nan)},
	{complex(-1, zero), complex(nan, inf), complex(zero, zero)},
	{complex(-1, zero), complex(nan, -inf), complex(zero, -zero)},
	{complex(-1, -zero), complex(zero, zero), complex(-inf, nan)},
	{complex(-1, -zero), complex(zero, -zero), complex(-inf, nan)},
	{complex(-1, -zero), complex(zero, 1), complex(-zero, 1)},
	{complex(-1, -zero), complex(zero, -1), complex(-zero, -1)},
	{complex(-1, -zero), complex(zero, 2), complex(-zero, 0.5)},
	{complex(-1, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(-1, -zero), complex(nan, inf), complex(zero, zero)},
	{complex(-1, -zero), complex(nan, -inf), complex(zero, -zero)},
	{complex(-1, -zero), complex(zero, zero), complex(-inf, nan)},
	{complex(-1, -zero), complex(-zero, -zero), complex(inf, nan)},
	{complex(-1, -zero), complex(zero, 1), complex(-zero, 1)},
	{complex(-1, -zero), complex(-zero, -1), complex(zero, -1)},
	{complex(-1, -zero), complex(zero, 2), complex(-zero, 0.5)},
	{complex(-1, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(-1, -zero), complex(nan, inf), complex(zero, zero)},
	{complex(-1, -zero), complex(nan, -inf), complex(zero, -zero)},
	{complex(-1, -zero), complex(1, zero), complex(-1, zero)},
	{complex(-1, -zero), complex(1, -zero), complex(-1, -zero)},
	{complex(-1, -zero), complex(1, 1), complex(-0.5, 0.5)},
	{complex(-1, -zero), complex(1, -1), complex(-0.5, -0.5)},
	{complex(-1, -zero), complex(1, 2), complex(-0.2, 0.4)},
	{complex(-1, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(-1, -zero), complex(nan, inf), complex(zero, zero)},
	{complex(-1, -zero), complex(nan, -inf), complex(zero, -zero)},
	{complex(-1, -zero), complex(-1, zero), complex(1, zero)},
	{complex(-1, -zero), complex(-1, -zero), complex(1, -zero)},
	{complex(-1, -zero), complex(-1, 1), complex(0.5, 0.5)},
	{complex(-1, -zero), complex(-1, -1), complex(0.5, -0.5)},
	{complex(-1, -zero), complex(-1, 2), complex(0.2, 0.4)},
	{complex(-1, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(-1, -zero), complex(nan, inf), complex(zero, zero)},
	{complex(-1, -zero), complex(nan, -inf), complex(zero, -zero)},
	{complex(-1, -zero), complex(2, zero), complex(-0.5, zero)},
	{complex(-1, -zero), complex(2, -zero), complex(-0.5, -zero)},
	{complex(-1, -zero), complex(2, 1), complex(-0.4, 0.2)},
	{complex(-1, -zero), complex(2, -1), complex(-0.4, -0.2)},
	{complex(-1, -zero), complex(2, 2), complex(-0.25, 0.25)},
	{complex(-1, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(-1, -zero), complex(nan, inf), complex(zero, zero)},
	{complex(-1, -zero), complex(nan, -inf), complex(zero, -zero)},
	{complex(-1, -zero), complex(nan, zero), complex(nan, nan)},
	{complex(-1, -zero), complex(nan, -zero), complex(nan, nan)},
	{complex(-1, -zero), complex(nan, 1), complex(nan, nan)},
	{complex(-1, -zero), complex(nan, -1), complex(nan, nan)},
	{complex(-1, -zero), complex(nan, 2), complex(nan, nan)},
	{complex(-1, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(-1, -zero), complex(nan, inf), complex(zero, zero)},
	{complex(-1, -zero), complex(nan, -inf), complex(zero, -zero)},
	{complex(-1, -zero), complex(inf, zero), complex(-zero, zero)},
	{complex(-1, -zero), complex(inf, -zero), complex(-zero, -zero)},
	{complex(-1, -zero), complex(inf, 1), complex(-zero, zero)},
	{complex(-1, -zero), complex(inf, -1), complex(-zero, -zero)},
	{complex(-1, -zero), complex(inf, 2), complex(-zero, zero)},
	{complex(-1, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(-1, -zero), complex(nan, inf), complex(zero, zero)},
	{complex(-1, -zero), complex(nan, -inf), complex(zero, -zero)},
	{complex(-1, -zero), complex(-inf, zero), complex(zero, zero)},
	{complex(-1, -zero), complex(-inf, -zero), complex(zero, -zero)},
	{complex(-1, -zero), complex(-inf, 1), complex(zero, zero)},
	{complex(-1, -zero), complex(-inf, -1), complex(zero, -zero)},
	{complex(-1, -zero), complex(-inf, 2), complex(zero, zero)},
	{complex(-1, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(-1, -zero), complex(nan, inf), complex(zero, zero)},
	{complex(-1, -zero), complex(nan, -inf), complex(zero, -zero)},
	{complex(-1, 1), complex(zero, zero), complex(-inf, inf)},
	{complex(-1, 1), complex(zero, -zero), complex(-inf, inf)},
	{complex(-1, 1), complex(zero, 1), complex(1, 1)},
	{complex(-1, 1), complex(zero, -1), complex(-1, -1)},
	{complex(-1, 1), complex(zero, 2), complex(0.5, 0.5)},
	{complex(-1, 1), complex(nan, nan), complex(nan, nan)},
	{complex(-1, 1), complex(nan, inf), complex(zero, zero)},
	{complex(-1, 1), complex(nan, -inf), complex(-zero, -zero)},
	{complex(-1, 1), complex(zero, zero), complex(-inf, inf)},
	{complex(-1, 1), complex(-zero, -zero), complex(inf, -inf)},
	{complex(-1, 1), complex(zero, 1), complex(1, 1)},
	{complex(-1, 1), complex(-zero, -1), complex(-1, -1)},
	{complex(-1, 1), complex(zero, 2), complex(0.5, 0.5)},
	{complex(-1, 1), complex(nan, nan), complex(nan, nan)},
	{complex(-1, 1), complex(nan, inf), complex(zero, zero)},
	{complex(-1, 1), complex(nan, -inf), complex(-zero, -zero)},
	{complex(-1, 1), complex(1, zero), complex(-1, 1)},
	{complex(-1, 1), complex(1, -zero), complex(-1, 1)},
	{complex(-1, 1), complex(1, 1), complex(zero, 1)},
	{complex(-1, 1), complex(1, -1), complex(-1, zero)},
	{complex(-1, 1), complex(1, 2), complex(0.2, 0.6)},
	{complex(-1, 1), complex(nan, nan), complex(nan, nan)},
	{complex(-1, 1), complex(nan, inf), complex(zero, zero)},
	{complex(-1, 1), complex(nan, -inf), complex(-zero, -zero)},
	{complex(-1, 1), complex(-1, zero), complex(1, -1)},
	{complex(-1, 1), complex(-1, -zero), complex(1, -1)},
	{complex(-1, 1), complex(-1, 1), complex(1, -zero)},
	{complex(-1, 1), complex(-1, -1), complex(-zero, -1)},
	{complex(-1, 1), complex(-1, 2), complex(0.6, 0.2)},
	{complex(-1, 1), complex(nan, nan), complex(nan, nan)},
	{complex(-1, 1), complex(nan, inf), complex(zero, zero)},
	{complex(-1, 1), complex(nan, -inf), complex(-zero, -zero)},
	{complex(-1, 1), complex(2, zero), complex(-0.5, 0.5)},
	{complex(-1, 1), complex(2, -zero), complex(-0.5, 0.5)},
	{complex(-1, 1), complex(2, 1), complex(-0.2, 0.6)},
	{complex(-1, 1), complex(2, -1), complex(-0.6, 0.2)},
	{complex(-1, 1), complex(2, 2), complex(zero, 0.5)},
	{complex(-1, 1), complex(nan, nan), complex(nan, nan)},
	{complex(-1, 1), complex(nan, inf), complex(zero, zero)},
	{complex(-1, 1), complex(nan, -inf), complex(-zero, -zero)},
	{complex(-1, 1), complex(nan, zero), complex(nan, nan)},
	{complex(-1, 1), complex(nan, -zero), complex(nan, nan)},
	{complex(-1, 1), complex(nan, 1), complex(nan, nan)},
	{complex(-1, 1), complex(nan, -1), complex(nan, nan)},
	{complex(-1, 1), complex(nan, 2), complex(nan, nan)},
	{complex(-1, 1), complex(nan, nan), complex(nan, nan)},
	{complex(-1, 1), complex(nan, inf), complex(zero, zero)},
	{complex(-1, 1), complex(nan, -inf), complex(-zero, -zero)},
	{complex(-1, 1), complex(inf, zero), complex(-zero, zero)},
	{complex(-1, 1), complex(inf, -zero), complex(-zero, zero)},
	{complex(-1, 1), complex(inf, 1), complex(-zero, zero)},
	{complex(-1, 1), complex(inf, -1), complex(-zero, zero)},
	{complex(-1, 1), complex(inf, 2), complex(-zero, zero)},
	{complex(-1, 1), complex(nan, nan), complex(nan, nan)},
	{complex(-1, 1), complex(nan, inf), complex(zero, zero)},
	{complex(-1, 1), complex(nan, -inf), complex(-zero, -zero)},
	{complex(-1, 1), complex(-inf, zero), complex(zero, -zero)},
	{complex(-1, 1), complex(-inf, -zero), complex(zero, -zero)},
	{complex(-1, 1), complex(-inf, 1), complex(zero, -zero)},
	{complex(-1, 1), complex(-inf, -1), complex(zero, -zero)},
	{complex(-1, 1), complex(-inf, 2), complex(zero, -zero)},
	{complex(-1, 1), complex(nan, nan), complex(nan, nan)},
	{complex(-1, 1), complex(nan, inf), complex(zero, zero)},
	{complex(-1, 1), complex(nan, -inf), complex(-zero, -zero)},
	{complex(-1, -1), complex(zero, zero), complex(-inf, -inf)},
	{complex(-1, -1), complex(zero, -zero), complex(-inf, -inf)},
	{complex(-1, -1), complex(zero, 1), complex(-1, 1)},
	{complex(-1, -1), complex(zero, -1), complex(1, -1)},
	{complex(-1, -1), complex(zero, 2), complex(-0.5, 0.5)},
	{complex(-1, -1), complex(nan, nan), complex(nan, nan)},
	{complex(-1, -1), complex(nan, inf), complex(-zero, zero)},
	{complex(-1, -1), complex(nan, -inf), complex(zero, -zero)},
	{complex(-1, -1), complex(zero, zero), complex(-inf, -inf)},
	{complex(-1, -1), complex(-zero, -zero), complex(inf, inf)},
	{complex(-1, -1), complex(zero, 1), complex(-1, 1)},
	{complex(-1, -1), complex(-zero, -1), complex(1, -1)},
	{complex(-1, -1), complex(zero, 2), complex(-0.5, 0.5)},
	{complex(-1, -1), complex(nan, nan), complex(nan, nan)},
	{complex(-1, -1), complex(nan, inf), complex(-zero, zero)},
	{complex(-1, -1), complex(nan, -inf), complex(zero, -zero)},
	{complex(-1, -1), complex(1, zero), complex(-1, -1)},
	{complex(-1, -1), complex(1, -zero), complex(-1, -1)},
	{complex(-1, -1), complex(1, 1), complex(-1, zero)},
	{complex(-1, -1), complex(1, -1), complex(zero, -1)},
	{complex(-1, -1), complex(1, 2), complex(-0.6, 0.2)},
	{complex(-1, -1), complex(nan, nan), complex(nan, nan)},
	{complex(-1, -1), complex(nan, inf), complex(-zero, zero)},
	{complex(-1, -1), complex(nan, -inf), complex(zero, -zero)},
	{complex(-1, -1), complex(-1, zero), complex(1, 1)},
	{complex(-1, -1), complex(-1, -zero), complex(1, 1)},
	{complex(-1, -1), complex(-1, 1), complex(-zero, 1)},
	{complex(-1, -1), complex(-1, -1), complex(1, -zero)},
	{complex(-1, -1), complex(-1, 2), complex(-0.2, 0.6)},
	{complex(-1, -1), complex(nan, nan), complex(nan, nan)},
	{complex(-1, -1), complex(nan, inf), complex(-zero, zero)},
	{complex(-1, -1), complex(nan, -inf), complex(zero, -zero)},
	{complex(-1, -1), complex(2, zero), complex(-0.5, -0.5)},
	{complex(-1, -1), complex(2, -zero), complex(-0.5, -0.5)},
	{complex(-1, -1), complex(2, 1), complex(-0.6, -0.2)},
	{complex(-1, -1), complex(2, -1), complex(-0.2, -0.6)},
	{complex(-1, -1), complex(2, 2), complex(-0.5, zero)},
	{complex(-1, -1), complex(nan, nan), complex(nan, nan)},
	{complex(-1, -1), complex(nan, inf), complex(-zero, zero)},
	{complex(-1, -1), complex(nan, -inf), complex(zero, -zero)},
	{complex(-1, -1), complex(nan, zero), complex(nan, nan)},
	{complex(-1, -1), complex(nan, -zero), complex(nan, nan)},
	{complex(-1, -1), complex(nan, 1), complex(nan, nan)},
	{complex(-1, -1), complex(nan, -1), complex(nan, nan)},
	{complex(-1, -1), complex(nan, 2), complex(nan, nan)},
	{complex(-1, -1), complex(nan, nan), complex(nan, nan)},
	{complex(-1, -1), complex(nan, inf), complex(-zero, zero)},
	{complex(-1, -1), complex(nan, -inf), complex(zero, -zero)},
	{complex(-1, -1), complex(inf, zero), complex(-zero, -zero)},
	{complex(-1, -1), complex(inf, -zero), complex(-zero, -zero)},
	{complex(-1, -1), complex(inf, 1), complex(-zero, -zero)},
	{complex(-1, -1), complex(inf, -1), complex(-zero, -zero)},
	{complex(-1, -1), complex(inf, 2), complex(-zero, -zero)},
	{complex(-1, -1), complex(nan, nan), complex(nan, nan)},
	{complex(-1, -1), complex(nan, inf), complex(-zero, zero)},
	{complex(-1, -1), complex(nan, -inf), complex(zero, -zero)},
	{complex(-1, -1), complex(-inf, zero), complex(zero, zero)},
	{complex(-1, -1), complex(-inf, -zero), complex(zero, zero)},
	{complex(-1, -1), complex(-inf, 1), complex(zero, zero)},
	{complex(-1, -1), complex(-inf, -1), complex(zero, zero)},
	{complex(-1, -1), complex(-inf, 2), complex(zero, zero)},
	{complex(-1, -1), complex(nan, nan), complex(nan, nan)},
	{complex(-1, -1), complex(nan, inf), complex(-zero, zero)},
	{complex(-1, -1), complex(nan, -inf), complex(zero, -zero)},
	{complex(-1, 2), complex(zero, zero), complex(-inf, inf)},
	{complex(-1, 2), complex(zero, -zero), complex(-inf, inf)},
	{complex(-1, 2), complex(zero, 1), complex(2, 1)},
	{complex(-1, 2), complex(zero, -1), complex(-2, -1)},
	{complex(-1, 2), complex(zero, 2), complex(1, 0.5)},
	{complex(-1, 2), complex(nan, nan), complex(nan, nan)},
	{complex(-1, 2), complex(nan, inf), complex(zero, zero)},
	{complex(-1, 2), complex(nan, -inf), complex(-zero, -zero)},
	{complex(-1, 2), complex(zero, zero), complex(-inf, inf)},
	{complex(-1, 2), complex(-zero, -zero), complex(inf, -inf)},
	{complex(-1, 2), complex(zero, 1), complex(2, 1)},
	{complex(-1, 2), complex(-zero, -1), complex(-2, -1)},
	{complex(-1, 2), complex(zero, 2), complex(1, 0.5)},
	{complex(-1, 2), complex(nan, nan), complex(nan, nan)},
	{complex(-1, 2), complex(nan, inf), complex(zero, zero)},
	{complex(-1, 2), complex(nan, -inf), complex(-zero, -zero)},
	{complex(-1, 2), complex(1, zero), complex(-1, 2)},
	{complex(-1, 2), complex(1, -zero), complex(-1, 2)},
	{complex(-1, 2), complex(1, 1), complex(0.5, 1.5)},
	{complex(-1, 2), complex(1, -1), complex(-1.5, 0.5)},
	{complex(-1, 2), complex(1, 2), complex(0.6, 0.8)},
	{complex(-1, 2), complex(nan, nan), complex(nan, nan)},
	{complex(-1, 2), complex(nan, inf), complex(zero, zero)},
	{complex(-1, 2), complex(nan, -inf), complex(-zero, -zero)},
	{complex(-1, 2), complex(-1, zero), complex(1, -2)},
	{complex(-1, 2), complex(-1, -zero), complex(1, -2)},
	{complex(-1, 2), complex(-1, 1), complex(1.5, -0.5)},
	{complex(-1, 2), complex(-1, -1), complex(-0.5, -1.5)},
	{complex(-1, 2), complex(-1, 2), complex(1, zero)},
	{complex(-1, 2), complex(nan, nan), complex(nan, nan)},
	{complex(-1, 2), complex(nan, inf), complex(zero, zero)},
	{complex(-1, 2), complex(nan, -inf), complex(-zero, -zero)},
	{complex(-1, 2), complex(2, zero), complex(-0.5, 1)},
	{complex(-1, 2), complex(2, -zero), complex(-0.5, 1)},
	{complex(-1, 2), complex(2, 1), complex(zero, 1)},
	{complex(-1, 2), complex(2, -1), complex(-0.8, 0.6)},
	{complex(-1, 2), complex(2, 2), complex(0.25, 0.75)},
	{complex(-1, 2), complex(nan, nan), complex(nan, nan)},
	{complex(-1, 2), complex(nan, inf), complex(zero, zero)},
	{complex(-1, 2), complex(nan, -inf), complex(-zero, -zero)},
	{complex(-1, 2), complex(nan, zero), complex(nan, nan)},
	{complex(-1, 2), complex(nan, -zero), complex(nan, nan)},
	{complex(-1, 2), complex(nan, 1), complex(nan, nan)},
	{complex(-1, 2), complex(nan, -1), complex(nan, nan)},
	{complex(-1, 2), complex(nan, 2), complex(nan, nan)},
	{complex(-1, 2), complex(nan, nan), complex(nan, nan)},
	{complex(-1, 2), complex(nan, inf), complex(zero, zero)},
	{complex(-1, 2), complex(nan, -inf), complex(-zero, -zero)},
	{complex(-1, 2), complex(inf, zero), complex(-zero, zero)},
	{complex(-1, 2), complex(inf, -zero), complex(-zero, zero)},
	{complex(-1, 2), complex(inf, 1), complex(-zero, zero)},
	{complex(-1, 2), complex(inf, -1), complex(-zero, zero)},
	{complex(-1, 2), complex(inf, 2), complex(-zero, zero)},
	{complex(-1, 2), complex(nan, nan), complex(nan, nan)},
	{complex(-1, 2), complex(nan, inf), complex(zero, zero)},
	{complex(-1, 2), complex(nan, -inf), complex(-zero, -zero)},
	{complex(-1, 2), complex(-inf, zero), complex(zero, -zero)},
	{complex(-1, 2), complex(-inf, -zero), complex(zero, -zero)},
	{complex(-1, 2), complex(-inf, 1), complex(zero, -zero)},
	{complex(-1, 2), complex(-inf, -1), complex(zero, -zero)},
	{complex(-1, 2), complex(-inf, 2), complex(zero, -zero)},
	{complex(-1, 2), complex(nan, nan), complex(nan, nan)},
	{complex(-1, 2), complex(nan, inf), complex(zero, zero)},
	{complex(-1, 2), complex(nan, -inf), complex(-zero, -zero)},
	{complex(nan, nan), complex(zero, zero), complex(nan, nan)},
	{complex(nan, nan), complex(zero, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(zero, 1), complex(nan, nan)},
	{complex(nan, nan), complex(zero, -1), complex(nan, nan)},
	{complex(nan, nan), complex(zero, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(zero, zero), complex(nan, nan)},
	{complex(nan, nan), complex(-zero, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(zero, 1), complex(nan, nan)},
	{complex(nan, nan), complex(-zero, -1), complex(nan, nan)},
	{complex(nan, nan), complex(zero, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(1, zero), complex(nan, nan)},
	{complex(nan, nan), complex(1, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(1, 1), complex(nan, nan)},
	{complex(nan, nan), complex(1, -1), complex(nan, nan)},
	{complex(nan, nan), complex(1, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(-1, zero), complex(nan, nan)},
	{complex(nan, nan), complex(-1, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(-1, 1), complex(nan, nan)},
	{complex(nan, nan), complex(-1, -1), complex(nan, nan)},
	{complex(nan, nan), complex(-1, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(2, zero), complex(nan, nan)},
	{complex(nan, nan), complex(2, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(2, 1), complex(nan, nan)},
	{complex(nan, nan), complex(2, -1), complex(nan, nan)},
	{complex(nan, nan), complex(2, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, zero), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(nan, 1), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -1), complex(nan, nan)},
	{complex(nan, nan), complex(nan, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(inf, zero), complex(nan, nan)},
	{complex(nan, nan), complex(inf, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(inf, 1), complex(nan, nan)},
	{complex(nan, nan), complex(inf, -1), complex(nan, nan)},
	{complex(nan, nan), complex(inf, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, zero), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, 1), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, -1), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(zero, zero), complex(nan, inf)},
	{complex(nan, inf), complex(zero, -zero), complex(nan, inf)},
	{complex(nan, inf), complex(zero, 1), complex(inf, nan)},
	{complex(nan, inf), complex(zero, -1), complex(-inf, nan)},
	{complex(nan, inf), complex(zero, 2), complex(inf, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(zero, zero), complex(nan, inf)},
	{complex(nan, inf), complex(-zero, -zero), complex(nan, -inf)},
	{complex(nan, inf), complex(zero, 1), complex(inf, nan)},
	{complex(nan, inf), complex(-zero, -1), complex(-inf, nan)},
	{complex(nan, inf), complex(zero, 2), complex(inf, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(1, zero), complex(nan, inf)},
	{complex(nan, inf), complex(1, -zero), complex(nan, inf)},
	{complex(nan, inf), complex(1, 1), complex(inf, inf)},
	{complex(nan, inf), complex(1, -1), complex(-inf, inf)},
	{complex(nan, inf), complex(1, 2), complex(inf, inf)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(-1, zero), complex(nan, -inf)},
	{complex(nan, inf), complex(-1, -zero), complex(nan, -inf)},
	{complex(nan, inf), complex(-1, 1), complex(inf, -inf)},
	{complex(nan, inf), complex(-1, -1), complex(-inf, -inf)},
	{complex(nan, inf), complex(-1, 2), complex(inf, -inf)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(2, zero), complex(nan, inf)},
	{complex(nan, inf), complex(2, -zero), complex(nan, inf)},
	{complex(nan, inf), complex(2, 1), complex(inf, inf)},
	{complex(nan, inf), complex(2, -1), complex(-inf, inf)},
	{complex(nan, inf), complex(2, 2), complex(inf, inf)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, zero), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -zero), complex(nan, nan)},
	{complex(nan, inf), complex(nan, 1), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -1), complex(nan, nan)},
	{complex(nan, inf), complex(nan, 2), complex(nan, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(inf, zero), complex(nan, nan)},
	{complex(nan, inf), complex(inf, -zero), complex(nan, nan)},
	{complex(nan, inf), complex(inf, 1), complex(nan, nan)},
	{complex(nan, inf), complex(inf, -1), complex(nan, nan)},
	{complex(nan, inf), complex(inf, 2), complex(nan, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, zero), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, -zero), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, 1), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, -1), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, 2), complex(nan, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(zero, zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(zero, -zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(zero, 1), complex(-inf, nan)},
	{complex(nan, -inf), complex(zero, -1), complex(inf, nan)},
	{complex(nan, -inf), complex(zero, 2), complex(-inf, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(zero, zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(-zero, -zero), complex(nan, inf)},
	{complex(nan, -inf), complex(zero, 1), complex(-inf, nan)},
	{complex(nan, -inf), complex(-zero, -1), complex(inf, nan)},
	{complex(nan, -inf), complex(zero, 2), complex(-inf, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(1, zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(1, -zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(1, 1), complex(-inf, -inf)},
	{complex(nan, -inf), complex(1, -1), complex(inf, -inf)},
	{complex(nan, -inf), complex(1, 2), complex(-inf, -inf)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(-1, zero), complex(nan, inf)},
	{complex(nan, -inf), complex(-1, -zero), complex(nan, inf)},
	{complex(nan, -inf), complex(-1, 1), complex(-inf, inf)},
	{complex(nan, -inf), complex(-1, -1), complex(inf, inf)},
	{complex(nan, -inf), complex(-1, 2), complex(-inf, inf)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(2, zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(2, -zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(2, 1), complex(-inf, -inf)},
	{complex(nan, -inf), complex(2, -1), complex(inf, -inf)},
	{complex(nan, -inf), complex(2, 2), complex(-inf, -inf)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, zero), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -zero), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, 1), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -1), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, 2), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, zero), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, -zero), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, 1), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, -1), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, 2), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, zero), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, -zero), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, 1), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, -1), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, 2), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(2, zero), complex(zero, zero), complex(inf, nan)},
	{complex(2, zero), complex(zero, -zero), complex(inf, nan)},
	{complex(2, zero), complex(zero, 1), complex(zero, -2)},
	{complex(2, zero), complex(zero, -1), complex(-zero, 2)},
	{complex(2, zero), complex(zero, 2), complex(zero, -1)},
	{complex(2, zero), complex(nan, nan), complex(nan, nan)},
	{complex(2, zero), complex(nan, inf), complex(zero, -zero)},
	{complex(2, zero), complex(nan, -inf), complex(-zero, zero)},
	{complex(2, zero), complex(zero, zero), complex(inf, nan)},
	{complex(2, zero), complex(-zero, -zero), complex(-inf, nan)},
	{complex(2, zero), complex(zero, 1), complex(zero, -2)},
	{complex(2, zero), complex(-zero, -1), complex(-zero, 2)},
	{complex(2, zero), complex(zero, 2), complex(zero, -1)},
	{complex(2, zero), complex(nan, nan), complex(nan, nan)},
	{complex(2, zero), complex(nan, inf), complex(zero, -zero)},
	{complex(2, zero), complex(nan, -inf), complex(-zero, zero)},
	{complex(2, zero), complex(1, zero), complex(2, zero)},
	{complex(2, zero), complex(1, -zero), complex(2, zero)},
	{complex(2, zero), complex(1, 1), complex(1, -1)},
	{complex(2, zero), complex(1, -1), complex(1, 1)},
	{complex(2, zero), complex(1, 2), complex(0.4, -0.8)},
	{complex(2, zero), complex(nan, nan), complex(nan, nan)},
	{complex(2, zero), complex(nan, inf), complex(zero, -zero)},
	{complex(2, zero), complex(nan, -inf), complex(-zero, zero)},
	{complex(2, zero), complex(-1, zero), complex(-2, -zero)},
	{complex(2, zero), complex(-1, -zero), complex(-2, -zero)},
	{complex(2, zero), complex(-1, 1), complex(-1, -1)},
	{complex(2, zero), complex(-1, -1), complex(-1, 1)},
	{complex(2, zero), complex(-1, 2), complex(-0.4, -0.8)},
	{complex(2, zero), complex(nan, nan), complex(nan, nan)},
	{complex(2, zero), complex(nan, inf), complex(zero, -zero)},
	{complex(2, zero), complex(nan, -inf), complex(-zero, zero)},
	{complex(2, zero), complex(2, zero), complex(1, zero)},
	{complex(2, zero), complex(2, -zero), complex(1, zero)},
	{complex(2, zero), complex(2, 1), complex(0.8, -0.4)},
	{complex(2, zero), complex(2, -1), complex(0.8, 0.4)},
	{complex(2, zero), complex(2, 2), complex(0.5, -0.5)},
	{complex(2, zero), complex(nan, nan), complex(nan, nan)},
	{complex(2, zero), complex(nan, inf), complex(zero, -zero)},
	{complex(2, zero), complex(nan, -inf), complex(-zero, zero)},
	{complex(2, zero), complex(nan, zero), complex(nan, nan)},
	{complex(2, zero), complex(nan, -zero), complex(nan, nan)},
	{complex(2, zero), complex(nan, 1), complex(nan, nan)},
	{complex(2, zero), complex(nan, -1), complex(nan, nan)},
	{complex(2, zero), complex(nan, 2), complex(nan, nan)},
	{complex(2, zero), complex(nan, nan), complex(nan, nan)},
	{complex(2, zero), complex(nan, inf), complex(zero, -zero)},
	{complex(2, zero), complex(nan, -inf), complex(-zero, zero)},
	{complex(2, zero), complex(inf, zero), complex(zero, zero)},
	{complex(2, zero), complex(inf, -zero), complex(zero, zero)},
	{complex(2, zero), complex(inf, 1), complex(zero, zero)},
	{complex(2, zero), complex(inf, -1), complex(zero, zero)},
	{complex(2, zero), complex(inf, 2), complex(zero, zero)},
	{complex(2, zero), complex(nan, nan), complex(nan, nan)},
	{complex(2, zero), complex(nan, inf), complex(zero, -zero)},
	{complex(2, zero), complex(nan, -inf), complex(-zero, zero)},
	{complex(2, zero), complex(-inf, zero), complex(-zero, -zero)},
	{complex(2, zero), complex(-inf, -zero), complex(-zero, -zero)},
	{complex(2, zero), complex(-inf, 1), complex(-zero, -zero)},
	{complex(2, zero), complex(-inf, -1), complex(-zero, -zero)},
	{complex(2, zero), complex(-inf, 2), complex(-zero, -zero)},
	{complex(2, zero), complex(nan, nan), complex(nan, nan)},
	{complex(2, zero), complex(nan, inf), complex(zero, -zero)},
	{complex(2, zero), complex(nan, -inf), complex(-zero, zero)},
	{complex(2, -zero), complex(zero, zero), complex(inf, nan)},
	{complex(2, -zero), complex(zero, -zero), complex(inf, nan)},
	{complex(2, -zero), complex(zero, 1), complex(zero, -2)},
	{complex(2, -zero), complex(zero, -1), complex(zero, 2)},
	{complex(2, -zero), complex(zero, 2), complex(zero, -1)},
	{complex(2, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(2, -zero), complex(nan, inf), complex(-zero, -zero)},
	{complex(2, -zero), complex(nan, -inf), complex(zero, zero)},
	{complex(2, -zero), complex(zero, zero), complex(inf, nan)},
	{complex(2, -zero), complex(-zero, -zero), complex(-inf, nan)},
	{complex(2, -zero), complex(zero, 1), complex(zero, -2)},
	{complex(2, -zero), complex(-zero, -1), complex(-zero, 2)},
	{complex(2, -zero), complex(zero, 2), complex(zero, -1)},
	{complex(2, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(2, -zero), complex(nan, inf), complex(-zero, -zero)},
	{complex(2, -zero), complex(nan, -inf), complex(zero, zero)},
	{complex(2, -zero), complex(1, zero), complex(2, -zero)},
	{complex(2, -zero), complex(1, -zero), complex(2, zero)},
	{complex(2, -zero), complex(1, 1), complex(1, -1)},
	{complex(2, -zero), complex(1, -1), complex(1, 1)},
	{complex(2, -zero), complex(1, 2), complex(0.4, -0.8)},
	{complex(2, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(2, -zero), complex(nan, inf), complex(-zero, -zero)},
	{complex(2, -zero), complex(nan, -inf), complex(zero, zero)},
	{complex(2, -zero), complex(-1, zero), complex(-2, -zero)},
	{complex(2, -zero), complex(-1, -zero), complex(-2, zero)},
	{complex(2, -zero), complex(-1, 1), complex(-1, -1)},
	{complex(2, -zero), complex(-1, -1), complex(-1, 1)},
	{complex(2, -zero), complex(-1, 2), complex(-0.4, -0.8)},
	{complex(2, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(2, -zero), complex(nan, inf), complex(-zero, -zero)},
	{complex(2, -zero), complex(nan, -inf), complex(zero, zero)},
	{complex(2, -zero), complex(2, zero), complex(1, -zero)},
	{complex(2, -zero), complex(2, -zero), complex(1, zero)},
	{complex(2, -zero), complex(2, 1), complex(0.8, -0.4)},
	{complex(2, -zero), complex(2, -1), complex(0.8, 0.4)},
	{complex(2, -zero), complex(2, 2), complex(0.5, -0.5)},
	{complex(2, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(2, -zero), complex(nan, inf), complex(-zero, -zero)},
	{complex(2, -zero), complex(nan, -inf), complex(zero, zero)},
	{complex(2, -zero), complex(nan, zero), complex(nan, nan)},
	{complex(2, -zero), complex(nan, -zero), complex(nan, nan)},
	{complex(2, -zero), complex(nan, 1), complex(nan, nan)},
	{complex(2, -zero), complex(nan, -1), complex(nan, nan)},
	{complex(2, -zero), complex(nan, 2), complex(nan, nan)},
	{complex(2, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(2, -zero), complex(nan, inf), complex(-zero, -zero)},
	{complex(2, -zero), complex(nan, -inf), complex(zero, zero)},
	{complex(2, -zero), complex(inf, zero), complex(zero, -zero)},
	{complex(2, -zero), complex(inf, -zero), complex(zero, zero)},
	{complex(2, -zero), complex(inf, 1), complex(zero, -zero)},
	{complex(2, -zero), complex(inf, -1), complex(zero, zero)},
	{complex(2, -zero), complex(inf, 2), complex(zero, -zero)},
	{complex(2, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(2, -zero), complex(nan, inf), complex(-zero, -zero)},
	{complex(2, -zero), complex(nan, -inf), complex(zero, zero)},
	{complex(2, -zero), complex(-inf, zero), complex(-zero, -zero)},
	{complex(2, -zero), complex(-inf, -zero), complex(-zero, zero)},
	{complex(2, -zero), complex(-inf, 1), complex(-zero, -zero)},
	{complex(2, -zero), complex(-inf, -1), complex(-zero, zero)},
	{complex(2, -zero), complex(-inf, 2), complex(-zero, -zero)},
	{complex(2, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(2, -zero), complex(nan, inf), complex(-zero, -zero)},
	{complex(2, -zero), complex(nan, -inf), complex(zero, zero)},
	{complex(2, 1), complex(zero, zero), complex(inf, inf)},
	{complex(2, 1), complex(zero, -zero), complex(inf, inf)},
	{complex(2, 1), complex(zero, 1), complex(1, -2)},
	{complex(2, 1), complex(zero, -1), complex(-1, 2)},
	{complex(2, 1), complex(zero, 2), complex(0.5, -1)},
	{complex(2, 1), complex(nan, nan), complex(nan, nan)},
	{complex(2, 1), complex(nan, inf), complex(zero, -zero)},
	{complex(2, 1), complex(nan, -inf), complex(-zero, zero)},
	{complex(2, 1), complex(zero, zero), complex(inf, inf)},
	{complex(2, 1), complex(-zero, -zero), complex(-inf, -inf)},
	{complex(2, 1), complex(zero, 1), complex(1, -2)},
	{complex(2, 1), complex(-zero, -1), complex(-1, 2)},
	{complex(2, 1), complex(zero, 2), complex(0.5, -1)},
	{complex(2, 1), complex(nan, nan), complex(nan, nan)},
	{complex(2, 1), complex(nan, inf), complex(zero, -zero)},
	{complex(2, 1), complex(nan, -inf), complex(-zero, zero)},
	{complex(2, 1), complex(1, zero), complex(2, 1)},
	{complex(2, 1), complex(1, -zero), complex(2, 1)},
	{complex(2, 1), complex(1, 1), complex(1.5, -0.5)},
	{complex(2, 1), complex(1, -1), complex(0.5, 1.5)},
	{complex(2, 1), complex(1, 2), complex(0.8, -0.6)},
	{complex(2, 1), complex(nan, nan), complex(nan, nan)},
	{complex(2, 1), complex(nan, inf), complex(zero, -zero)},
	{complex(2, 1), complex(nan, -inf), complex(-zero, zero)},
	{complex(2, 1), complex(-1, zero), complex(-2, -1)},
	{complex(2, 1), complex(-1, -zero), complex(-2, -1)},
	{complex(2, 1), complex(-1, 1), complex(-0.5, -1.5)},
	{complex(2, 1), complex(-1, -1), complex(-1.5, 0.5)},
	{complex(2, 1), complex(-1, 2), complex(zero, -1)},
	{complex(2, 1), complex(nan, nan), complex(nan, nan)},
	{complex(2, 1), complex(nan, inf), complex(zero, -zero)},
	{complex(2, 1), complex(nan, -inf), complex(-zero, zero)},
	{complex(2, 1), complex(2, zero), complex(1, 0.5)},
	{complex(2, 1), complex(2, -zero), complex(1, 0.5)},
	{complex(2, 1), complex(2, 1), complex(1, zero)},
	{complex(2, 1), complex(2, -1), complex(0.6, 0.8)},
	{complex(2, 1), complex(2, 2), complex(0.75, -0.25)},
	{complex(2, 1), complex(nan, nan), complex(nan, nan)},
	{complex(2, 1), complex(nan, inf), complex(zero, -zero)},
	{complex(2, 1), complex(nan, -inf), complex(-zero, zero)},
	{complex(2, 1), complex(nan, zero), complex(nan, nan)},
	{complex(2, 1), complex(nan, -zero), complex(nan, nan)},
	{complex(2, 1), complex(nan, 1), complex(nan, nan)},
	{complex(2, 1), complex(nan, -1), complex(nan, nan)},
	{complex(2, 1), complex(nan, 2), complex(nan, nan)},
	{complex(2, 1), complex(nan, nan), complex(nan, nan)},
	{complex(2, 1), complex(nan, inf), complex(zero, -zero)},
	{complex(2, 1), complex(nan, -inf), complex(-zero, zero)},
	{complex(2, 1), complex(inf, zero), complex(zero, zero)},
	{complex(2, 1), complex(inf, -zero), complex(zero, zero)},
	{complex(2, 1), complex(inf, 1), complex(zero, zero)},
	{complex(2, 1), complex(inf, -1), complex(zero, zero)},
	{complex(2, 1), complex(inf, 2), complex(zero, zero)},
	{complex(2, 1), complex(nan, nan), complex(nan, nan)},
	{complex(2, 1), complex(nan, inf), complex(zero, -zero)},
	{complex(2, 1), complex(nan, -inf), complex(-zero, zero)},
	{complex(2, 1), complex(-inf, zero), complex(-zero, -zero)},
	{complex(2, 1), complex(-inf, -zero), complex(-zero, -zero)},
	{complex(2, 1), complex(-inf, 1), complex(-zero, -zero)},
	{complex(2, 1), complex(-inf, -1), complex(-zero, -zero)},
	{complex(2, 1), complex(-inf, 2), complex(-zero, -zero)},
	{complex(2, 1), complex(nan, nan), complex(nan, nan)},
	{complex(2, 1), complex(nan, inf), complex(zero, -zero)},
	{complex(2, 1), complex(nan, -inf), complex(-zero, zero)},
	{complex(2, -1), complex(zero, zero), complex(inf, -inf)},
	{complex(2, -1), complex(zero, -zero), complex(inf, -inf)},
	{complex(2, -1), complex(zero, 1), complex(-1, -2)},
	{complex(2, -1), complex(zero, -1), complex(1, 2)},
	{complex(2, -1), complex(zero, 2), complex(-0.5, -1)},
	{complex(2, -1), complex(nan, nan), complex(nan, nan)},
	{complex(2, -1), complex(nan, inf), complex(-zero, -zero)},
	{complex(2, -1), complex(nan, -inf), complex(zero, zero)},
	{complex(2, -1), complex(zero, zero), complex(inf, -inf)},
	{complex(2, -1), complex(-zero, -zero), complex(-inf, inf)},
	{complex(2, -1), complex(zero, 1), complex(-1, -2)},
	{complex(2, -1), complex(-zero, -1), complex(1, 2)},
	{complex(2, -1), complex(zero, 2), complex(-0.5, -1)},
	{complex(2, -1), complex(nan, nan), complex(nan, nan)},
	{complex(2, -1), complex(nan, inf), complex(-zero, -zero)},
	{complex(2, -1), complex(nan, -inf), complex(zero, zero)},
	{complex(2, -1), complex(1, zero), complex(2, -1)},
	{complex(2, -1), complex(1, -zero), complex(2, -1)},
	{complex(2, -1), complex(1, 1), complex(0.5, -1.5)},
	{complex(2, -1), complex(1, -1), complex(1.5, 0.5)},
	{complex(2, -1), complex(1, 2), complex(zero, -1)},
	{complex(2, -1), complex(nan, nan), complex(nan, nan)},
	{complex(2, -1), complex(nan, inf), complex(-zero, -zero)},
	{complex(2, -1), complex(nan, -inf), complex(zero, zero)},
	{complex(2, -1), complex(-1, zero), complex(-2, 1)},
	{complex(2, -1), complex(-1, -zero), complex(-2, 1)},
	{complex(2, -1), complex(-1, 1), complex(-1.5, -0.5)},
	{complex(2, -1), complex(-1, -1), complex(-0.5, 1.5)},
	{complex(2, -1), complex(-1, 2), complex(-0.8, -0.6)},
	{complex(2, -1), complex(nan, nan), complex(nan, nan)},
	{complex(2, -1), complex(nan, inf), complex(-zero, -zero)},
	{complex(2, -1), complex(nan, -inf), complex(zero, zero)},
	{complex(2, -1), complex(2, zero), complex(1, -0.5)},
	{complex(2, -1), complex(2, -zero), complex(1, -0.5)},
	{complex(2, -1), complex(2, 1), complex(0.6, -0.8)},
	{complex(2, -1), complex(2, -1), complex(1, zero)},
	{complex(2, -1), complex(2, 2), complex(0.25, -0.75)},
	{complex(2, -1), complex(nan, nan), complex(nan, nan)},
	{complex(2, -1), complex(nan, inf), complex(-zero, -zero)},
	{complex(2, -1), complex(nan, -inf), complex(zero, zero)},
	{complex(2, -1), complex(nan, zero), complex(nan, nan)},
	{complex(2, -1), complex(nan, -zero), complex(nan, nan)},
	{complex(2, -1), complex(nan, 1), complex(nan, nan)},
	{complex(2, -1), complex(nan, -1), complex(nan, nan)},
	{complex(2, -1), complex(nan, 2), complex(nan, nan)},
	{complex(2, -1), complex(nan, nan), complex(nan, nan)},
	{complex(2, -1), complex(nan, inf), complex(-zero, -zero)},
	{complex(2, -1), complex(nan, -inf), complex(zero, zero)},
	{complex(2, -1), complex(inf, zero), complex(zero, -zero)},
	{complex(2, -1), complex(inf, -zero), complex(zero, -zero)},
	{complex(2, -1), complex(inf, 1), complex(zero, -zero)},
	{complex(2, -1), complex(inf, -1), complex(zero, -zero)},
	{complex(2, -1), complex(inf, 2), complex(zero, -zero)},
	{complex(2, -1), complex(nan, nan), complex(nan, nan)},
	{complex(2, -1), complex(nan, inf), complex(-zero, -zero)},
	{complex(2, -1), complex(nan, -inf), complex(zero, zero)},
	{complex(2, -1), complex(-inf, zero), complex(-zero, zero)},
	{complex(2, -1), complex(-inf, -zero), complex(-zero, zero)},
	{complex(2, -1), complex(-inf, 1), complex(-zero, zero)},
	{complex(2, -1), complex(-inf, -1), complex(-zero, zero)},
	{complex(2, -1), complex(-inf, 2), complex(-zero, zero)},
	{complex(2, -1), complex(nan, nan), complex(nan, nan)},
	{complex(2, -1), complex(nan, inf), complex(-zero, -zero)},
	{complex(2, -1), complex(nan, -inf), complex(zero, zero)},
	{complex(2, 2), complex(zero, zero), complex(inf, inf)},
	{complex(2, 2), complex(zero, -zero), complex(inf, inf)},
	{complex(2, 2), complex(zero, 1), complex(2, -2)},
	{complex(2, 2), complex(zero, -1), complex(-2, 2)},
	{complex(2, 2), complex(zero, 2), complex(1, -1)},
	{complex(2, 2), complex(nan, nan), complex(nan, nan)},
	{complex(2, 2), complex(nan, inf), complex(zero, -zero)},
	{complex(2, 2), complex(nan, -inf), complex(-zero, zero)},
	{complex(2, 2), complex(zero, zero), complex(inf, inf)},
	{complex(2, 2), complex(-zero, -zero), complex(-inf, -inf)},
	{complex(2, 2), complex(zero, 1), complex(2, -2)},
	{complex(2, 2), complex(-zero, -1), complex(-2, 2)},
	{complex(2, 2), complex(zero, 2), complex(1, -1)},
	{complex(2, 2), complex(nan, nan), complex(nan, nan)},
	{complex(2, 2), complex(nan, inf), complex(zero, -zero)},
	{complex(2, 2), complex(nan, -inf), complex(-zero, zero)},
	{complex(2, 2), complex(1, zero), complex(2, 2)},
	{complex(2, 2), complex(1, -zero), complex(2, 2)},
	{complex(2, 2), complex(1, 1), complex(2, zero)},
	{complex(2, 2), complex(1, -1), complex(zero, 2)},
	{complex(2, 2), complex(1, 2), complex(1.2, -0.4)},
	{complex(2, 2), complex(nan, nan), complex(nan, nan)},
	{complex(2, 2), complex(nan, inf), complex(zero, -zero)},
	{complex(2, 2), complex(nan, -inf), complex(-zero, zero)},
	{complex(2, 2), complex(-1, zero), complex(-2, -2)},
	{complex(2, 2), complex(-1, -zero), complex(-2, -2)},
	{complex(2, 2), complex(-1, 1), complex(-zero, -2)},
	{complex(2, 2), complex(-1, -1), complex(-2, -zero)},
	{complex(2, 2), complex(-1, 2), complex(0.4, -1.2)},
	{complex(2, 2), complex(nan, nan), complex(nan, nan)},
	{complex(2, 2), complex(nan, inf), complex(zero, -zero)},
	{complex(2, 2), complex(nan, -inf), complex(-zero, zero)},
	{complex(2, 2), complex(2, zero), complex(1, 1)},
	{complex(2, 2), complex(2, -zero), complex(1, 1)},
	{complex(2, 2), complex(2, 1), complex(1.2, 0.4)},
	{complex(2, 2), complex(2, -1), complex(0.4, 1.2)},
	{complex(2, 2), complex(2, 2), complex(1, zero)},
	{complex(2, 2), complex(nan, nan), complex(nan, nan)},
	{complex(2, 2), complex(nan, inf), complex(zero, -zero)},
	{complex(2, 2), complex(nan, -inf), complex(-zero, zero)},
	{complex(2, 2), complex(nan, zero), complex(nan, nan)},
	{complex(2, 2), complex(nan, -zero), complex(nan, nan)},
	{complex(2, 2), complex(nan, 1), complex(nan, nan)},
	{complex(2, 2), complex(nan, -1), complex(nan, nan)},
	{complex(2, 2), complex(nan, 2), complex(nan, nan)},
	{complex(2, 2), complex(nan, nan), complex(nan, nan)},
	{complex(2, 2), complex(nan, inf), complex(zero, -zero)},
	{complex(2, 2), complex(nan, -inf), complex(-zero, zero)},
	{complex(2, 2), complex(inf, zero), complex(zero, zero)},
	{complex(2, 2), complex(inf, -zero), complex(zero, zero)},
	{complex(2, 2), complex(inf, 1), complex(zero, zero)},
	{complex(2, 2), complex(inf, -1), complex(zero, zero)},
	{complex(2, 2), complex(inf, 2), complex(zero, zero)},
	{complex(2, 2), complex(nan, nan), complex(nan, nan)},
	{complex(2, 2), complex(nan, inf), complex(zero, -zero)},
	{complex(2, 2), complex(nan, -inf), complex(-zero, zero)},
	{complex(2, 2), complex(-inf, zero), complex(-zero, -zero)},
	{complex(2, 2), complex(-inf, -zero), complex(-zero, -zero)},
	{complex(2, 2), complex(-inf, 1), complex(-zero, -zero)},
	{complex(2, 2), complex(-inf, -1), complex(-zero, -zero)},
	{complex(2, 2), complex(-inf, 2), complex(-zero, -zero)},
	{complex(2, 2), complex(nan, nan), complex(nan, nan)},
	{complex(2, 2), complex(nan, inf), complex(zero, -zero)},
	{complex(2, 2), complex(nan, -inf), complex(-zero, zero)},
	{complex(nan, nan), complex(zero, zero), complex(nan, nan)},
	{complex(nan, nan), complex(zero, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(zero, 1), complex(nan, nan)},
	{complex(nan, nan), complex(zero, -1), complex(nan, nan)},
	{complex(nan, nan), complex(zero, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(zero, zero), complex(nan, nan)},
	{complex(nan, nan), complex(-zero, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(zero, 1), complex(nan, nan)},
	{complex(nan, nan), complex(-zero, -1), complex(nan, nan)},
	{complex(nan, nan), complex(zero, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(1, zero), complex(nan, nan)},
	{complex(nan, nan), complex(1, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(1, 1), complex(nan, nan)},
	{complex(nan, nan), complex(1, -1), complex(nan, nan)},
	{complex(nan, nan), complex(1, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(-1, zero), complex(nan, nan)},
	{complex(nan, nan), complex(-1, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(-1, 1), complex(nan, nan)},
	{complex(nan, nan), complex(-1, -1), complex(nan, nan)},
	{complex(nan, nan), complex(-1, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(2, zero), complex(nan, nan)},
	{complex(nan, nan), complex(2, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(2, 1), complex(nan, nan)},
	{complex(nan, nan), complex(2, -1), complex(nan, nan)},
	{complex(nan, nan), complex(2, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, zero), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(nan, 1), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -1), complex(nan, nan)},
	{complex(nan, nan), complex(nan, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(inf, zero), complex(nan, nan)},
	{complex(nan, nan), complex(inf, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(inf, 1), complex(nan, nan)},
	{complex(nan, nan), complex(inf, -1), complex(nan, nan)},
	{complex(nan, nan), complex(inf, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, zero), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, 1), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, -1), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(zero, zero), complex(nan, inf)},
	{complex(nan, inf), complex(zero, -zero), complex(nan, inf)},
	{complex(nan, inf), complex(zero, 1), complex(inf, nan)},
	{complex(nan, inf), complex(zero, -1), complex(-inf, nan)},
	{complex(nan, inf), complex(zero, 2), complex(inf, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(zero, zero), complex(nan, inf)},
	{complex(nan, inf), complex(-zero, -zero), complex(nan, -inf)},
	{complex(nan, inf), complex(zero, 1), complex(inf, nan)},
	{complex(nan, inf), complex(-zero, -1), complex(-inf, nan)},
	{complex(nan, inf), complex(zero, 2), complex(inf, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(1, zero), complex(nan, inf)},
	{complex(nan, inf), complex(1, -zero), complex(nan, inf)},
	{complex(nan, inf), complex(1, 1), complex(inf, inf)},
	{complex(nan, inf), complex(1, -1), complex(-inf, inf)},
	{complex(nan, inf), complex(1, 2), complex(inf, inf)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(-1, zero), complex(nan, -inf)},
	{complex(nan, inf), complex(-1, -zero), complex(nan, -inf)},
	{complex(nan, inf), complex(-1, 1), complex(inf, -inf)},
	{complex(nan, inf), complex(-1, -1), complex(-inf, -inf)},
	{complex(nan, inf), complex(-1, 2), complex(inf, -inf)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(2, zero), complex(nan, inf)},
	{complex(nan, inf), complex(2, -zero), complex(nan, inf)},
	{complex(nan, inf), complex(2, 1), complex(inf, inf)},
	{complex(nan, inf), complex(2, -1), complex(-inf, inf)},
	{complex(nan, inf), complex(2, 2), complex(inf, inf)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, zero), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -zero), complex(nan, nan)},
	{complex(nan, inf), complex(nan, 1), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -1), complex(nan, nan)},
	{complex(nan, inf), complex(nan, 2), complex(nan, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(inf, zero), complex(nan, nan)},
	{complex(nan, inf), complex(inf, -zero), complex(nan, nan)},
	{complex(nan, inf), complex(inf, 1), complex(nan, nan)},
	{complex(nan, inf), complex(inf, -1), complex(nan, nan)},
	{complex(nan, inf), complex(inf, 2), complex(nan, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, zero), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, -zero), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, 1), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, -1), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, 2), complex(nan, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(zero, zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(zero, -zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(zero, 1), complex(-inf, nan)},
	{complex(nan, -inf), complex(zero, -1), complex(inf, nan)},
	{complex(nan, -inf), complex(zero, 2), complex(-inf, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(zero, zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(-zero, -zero), complex(nan, inf)},
	{complex(nan, -inf), complex(zero, 1), complex(-inf, nan)},
	{complex(nan, -inf), complex(-zero, -1), complex(inf, nan)},
	{complex(nan, -inf), complex(zero, 2), complex(-inf, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(1, zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(1, -zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(1, 1), complex(-inf, -inf)},
	{complex(nan, -inf), complex(1, -1), complex(inf, -inf)},
	{complex(nan, -inf), complex(1, 2), complex(-inf, -inf)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(-1, zero), complex(nan, inf)},
	{complex(nan, -inf), complex(-1, -zero), complex(nan, inf)},
	{complex(nan, -inf), complex(-1, 1), complex(-inf, inf)},
	{complex(nan, -inf), complex(-1, -1), complex(inf, inf)},
	{complex(nan, -inf), complex(-1, 2), complex(-inf, inf)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(2, zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(2, -zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(2, 1), complex(-inf, -inf)},
	{complex(nan, -inf), complex(2, -1), complex(inf, -inf)},
	{complex(nan, -inf), complex(2, 2), complex(-inf, -inf)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, zero), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -zero), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, 1), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -1), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, 2), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, zero), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, -zero), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, 1), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, -1), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, 2), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, zero), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, -zero), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, 1), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, -1), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, 2), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, zero), complex(zero, zero), complex(nan, nan)},
	{complex(nan, zero), complex(zero, -zero), complex(nan, nan)},
	{complex(nan, zero), complex(zero, 1), complex(nan, nan)},
	{complex(nan, zero), complex(zero, -1), complex(nan, nan)},
	{complex(nan, zero), complex(zero, 2), complex(nan, nan)},
	{complex(nan, zero), complex(nan, nan), complex(nan, nan)},
	{complex(nan, zero), complex(nan, inf), complex(nan, nan)},
	{complex(nan, zero), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, zero), complex(zero, zero), complex(nan, nan)},
	{complex(nan, zero), complex(-zero, -zero), complex(nan, nan)},
	{complex(nan, zero), complex(zero, 1), complex(nan, nan)},
	{complex(nan, zero), complex(-zero, -1), complex(nan, nan)},
	{complex(nan, zero), complex(zero, 2), complex(nan, nan)},
	{complex(nan, zero), complex(nan, nan), complex(nan, nan)},
	{complex(nan, zero), complex(nan, inf), complex(nan, nan)},
	{complex(nan, zero), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, zero), complex(1, zero), complex(nan, nan)},
	{complex(nan, zero), complex(1, -zero), complex(nan, nan)},
	{complex(nan, zero), complex(1, 1), complex(nan, nan)},
	{complex(nan, zero), complex(1, -1), complex(nan, nan)},
	{complex(nan, zero), complex(1, 2), complex(nan, nan)},
	{complex(nan, zero), complex(nan, nan), complex(nan, nan)},
	{complex(nan, zero), complex(nan, inf), complex(nan, nan)},
	{complex(nan, zero), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, zero), complex(-1, zero), complex(nan, nan)},
	{complex(nan, zero), complex(-1, -zero), complex(nan, nan)},
	{complex(nan, zero), complex(-1, 1), complex(nan, nan)},
	{complex(nan, zero), complex(-1, -1), complex(nan, nan)},
	{complex(nan, zero), complex(-1, 2), complex(nan, nan)},
	{complex(nan, zero), complex(nan, nan), complex(nan, nan)},
	{complex(nan, zero), complex(nan, inf), complex(nan, nan)},
	{complex(nan, zero), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, zero), complex(2, zero), complex(nan, nan)},
	{complex(nan, zero), complex(2, -zero), complex(nan, nan)},
	{complex(nan, zero), complex(2, 1), complex(nan, nan)},
	{complex(nan, zero), complex(2, -1), complex(nan, nan)},
	{complex(nan, zero), complex(2, 2), complex(nan, nan)},
	{complex(nan, zero), complex(nan, nan), complex(nan, nan)},
	{complex(nan, zero), complex(nan, inf), complex(nan, nan)},
	{complex(nan, zero), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, zero), complex(nan, zero), complex(nan, nan)},
	{complex(nan, zero), complex(nan, -zero), complex(nan, nan)},
	{complex(nan, zero), complex(nan, 1), complex(nan, nan)},
	{complex(nan, zero), complex(nan, -1), complex(nan, nan)},
	{complex(nan, zero), complex(nan, 2), complex(nan, nan)},
	{complex(nan, zero), complex(nan, nan), complex(nan, nan)},
	{complex(nan, zero), complex(nan, inf), complex(nan, nan)},
	{complex(nan, zero), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, zero), complex(inf, zero), complex(nan, nan)},
	{complex(nan, zero), complex(inf, -zero), complex(nan, nan)},
	{complex(nan, zero), complex(inf, 1), complex(nan, nan)},
	{complex(nan, zero), complex(inf, -1), complex(nan, nan)},
	{complex(nan, zero), complex(inf, 2), complex(nan, nan)},
	{complex(nan, zero), complex(nan, nan), complex(nan, nan)},
	{complex(nan, zero), complex(nan, inf), complex(nan, nan)},
	{complex(nan, zero), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, zero), complex(-inf, zero), complex(nan, nan)},
	{complex(nan, zero), complex(-inf, -zero), complex(nan, nan)},
	{complex(nan, zero), complex(-inf, 1), complex(nan, nan)},
	{complex(nan, zero), complex(-inf, -1), complex(nan, nan)},
	{complex(nan, zero), complex(-inf, 2), complex(nan, nan)},
	{complex(nan, zero), complex(nan, nan), complex(nan, nan)},
	{complex(nan, zero), complex(nan, inf), complex(nan, nan)},
	{complex(nan, zero), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -zero), complex(zero, zero), complex(nan, nan)},
	{complex(nan, -zero), complex(zero, -zero), complex(nan, nan)},
	{complex(nan, -zero), complex(zero, 1), complex(nan, nan)},
	{complex(nan, -zero), complex(zero, -1), complex(nan, nan)},
	{complex(nan, -zero), complex(zero, 2), complex(nan, nan)},
	{complex(nan, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -zero), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -zero), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -zero), complex(zero, zero), complex(nan, nan)},
	{complex(nan, -zero), complex(-zero, -zero), complex(nan, nan)},
	{complex(nan, -zero), complex(zero, 1), complex(nan, nan)},
	{complex(nan, -zero), complex(-zero, -1), complex(nan, nan)},
	{complex(nan, -zero), complex(zero, 2), complex(nan, nan)},
	{complex(nan, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -zero), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -zero), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -zero), complex(1, zero), complex(nan, nan)},
	{complex(nan, -zero), complex(1, -zero), complex(nan, nan)},
	{complex(nan, -zero), complex(1, 1), complex(nan, nan)},
	{complex(nan, -zero), complex(1, -1), complex(nan, nan)},
	{complex(nan, -zero), complex(1, 2), complex(nan, nan)},
	{complex(nan, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -zero), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -zero), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -zero), complex(-1, zero), complex(nan, nan)},
	{complex(nan, -zero), complex(-1, -zero), complex(nan, nan)},
	{complex(nan, -zero), complex(-1, 1), complex(nan, nan)},
	{complex(nan, -zero), complex(-1, -1), complex(nan, nan)},
	{complex(nan, -zero), complex(-1, 2), complex(nan, nan)},
	{complex(nan, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -zero), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -zero), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -zero), complex(2, zero), complex(nan, nan)},
	{complex(nan, -zero), complex(2, -zero), complex(nan, nan)},
	{complex(nan, -zero), complex(2, 1), complex(nan, nan)},
	{complex(nan, -zero), complex(2, -1), complex(nan, nan)},
	{complex(nan, -zero), complex(2, 2), complex(nan, nan)},
	{complex(nan, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -zero), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -zero), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -zero), complex(nan, zero), complex(nan, nan)},
	{complex(nan, -zero), complex(nan, -zero), complex(nan, nan)},
	{complex(nan, -zero), complex(nan, 1), complex(nan, nan)},
	{complex(nan, -zero), complex(nan, -1), complex(nan, nan)},
	{complex(nan, -zero), complex(nan, 2), complex(nan, nan)},
	{complex(nan, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -zero), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -zero), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -zero), complex(inf, zero), complex(nan, nan)},
	{complex(nan, -zero), complex(inf, -zero), complex(nan, nan)},
	{complex(nan, -zero), complex(inf, 1), complex(nan, nan)},
	{complex(nan, -zero), complex(inf, -1), complex(nan, nan)},
	{complex(nan, -zero), complex(inf, 2), complex(nan, nan)},
	{complex(nan, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -zero), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -zero), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -zero), complex(-inf, zero), complex(nan, nan)},
	{complex(nan, -zero), complex(-inf, -zero), complex(nan, nan)},
	{complex(nan, -zero), complex(-inf, 1), complex(nan, nan)},
	{complex(nan, -zero), complex(-inf, -1), complex(nan, nan)},
	{complex(nan, -zero), complex(-inf, 2), complex(nan, nan)},
	{complex(nan, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -zero), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -zero), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, 1), complex(zero, zero), complex(nan, inf)},
	{complex(nan, 1), complex(zero, -zero), complex(nan, inf)},
	{complex(nan, 1), complex(zero, 1), complex(nan, nan)},
	{complex(nan, 1), complex(zero, -1), complex(nan, nan)},
	{complex(nan, 1), complex(zero, 2), complex(nan, nan)},
	{complex(nan, 1), complex(nan, nan), complex(nan, nan)},
	{complex(nan, 1), complex(nan, inf), complex(nan, nan)},
	{complex(nan, 1), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, 1), complex(zero, zero), complex(nan, inf)},
	{complex(nan, 1), complex(-zero, -zero), complex(nan, -inf)},
	{complex(nan, 1), complex(zero, 1), complex(nan, nan)},
	{complex(nan, 1), complex(-zero, -1), complex(nan, nan)},
	{complex(nan, 1), complex(zero, 2), complex(nan, nan)},
	{complex(nan, 1), complex(nan, nan), complex(nan, nan)},
	{complex(nan, 1), complex(nan, inf), complex(nan, nan)},
	{complex(nan, 1), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, 1), complex(1, zero), complex(nan, nan)},
	{complex(nan, 1), complex(1, -zero), complex(nan, nan)},
	{complex(nan, 1), complex(1, 1), complex(nan, nan)},
	{complex(nan, 1), complex(1, -1), complex(nan, nan)},
	{complex(nan, 1), complex(1, 2), complex(nan, nan)},
	{complex(nan, 1), complex(nan, nan), complex(nan, nan)},
	{complex(nan, 1), complex(nan, inf), complex(nan, nan)},
	{complex(nan, 1), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, 1), complex(-1, zero), complex(nan, nan)},
	{complex(nan, 1), complex(-1, -zero), complex(nan, nan)},
	{complex(nan, 1), complex(-1, 1), complex(nan, nan)},
	{complex(nan, 1), complex(-1, -1), complex(nan, nan)},
	{complex(nan, 1), complex(-1, 2), complex(nan, nan)},
	{complex(nan, 1), complex(nan, nan), complex(nan, nan)},
	{complex(nan, 1), complex(nan, inf), complex(nan, nan)},
	{complex(nan, 1), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, 1), complex(2, zero), complex(nan, nan)},
	{complex(nan, 1), complex(2, -zero), complex(nan, nan)},
	{complex(nan, 1), complex(2, 1), complex(nan, nan)},
	{complex(nan, 1), complex(2, -1), complex(nan, nan)},
	{complex(nan, 1), complex(2, 2), complex(nan, nan)},
	{complex(nan, 1), complex(nan, nan), complex(nan, nan)},
	{complex(nan, 1), complex(nan, inf), complex(nan, nan)},
	{complex(nan, 1), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, 1), complex(nan, zero), complex(nan, nan)},
	{complex(nan, 1), complex(nan, -zero), complex(nan, nan)},
	{complex(nan, 1), complex(nan, 1), complex(nan, nan)},
	{complex(nan, 1), complex(nan, -1), complex(nan, nan)},
	{complex(nan, 1), complex(nan, 2), complex(nan, nan)},
	{complex(nan, 1), complex(nan, nan), complex(nan, nan)},
	{complex(nan, 1), complex(nan, inf), complex(nan, nan)},
	{complex(nan, 1), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, 1), complex(inf, zero), complex(nan, nan)},
	{complex(nan, 1), complex(inf, -zero), complex(nan, nan)},
	{complex(nan, 1), complex(inf, 1), complex(nan, nan)},
	{complex(nan, 1), complex(inf, -1), complex(nan, nan)},
	{complex(nan, 1), complex(inf, 2), complex(nan, nan)},
	{complex(nan, 1), complex(nan, nan), complex(nan, nan)},
	{complex(nan, 1), complex(nan, inf), complex(nan, nan)},
	{complex(nan, 1), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, 1), complex(-inf, zero), complex(nan, nan)},
	{complex(nan, 1), complex(-inf, -zero), complex(nan, nan)},
	{complex(nan, 1), complex(-inf, 1), complex(nan, nan)},
	{complex(nan, 1), complex(-inf, -1), complex(nan, nan)},
	{complex(nan, 1), complex(-inf, 2), complex(nan, nan)},
	{complex(nan, 1), complex(nan, nan), complex(nan, nan)},
	{complex(nan, 1), complex(nan, inf), complex(nan, nan)},
	{complex(nan, 1), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -1), complex(zero, zero), complex(nan, -inf)},
	{complex(nan, -1), complex(zero, -zero), complex(nan, -inf)},
	{complex(nan, -1), complex(zero, 1), complex(nan, nan)},
	{complex(nan, -1), complex(zero, -1), complex(nan, nan)},
	{complex(nan, -1), complex(zero, 2), complex(nan, nan)},
	{complex(nan, -1), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -1), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -1), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -1), complex(zero, zero), complex(nan, -inf)},
	{complex(nan, -1), complex(-zero, -zero), complex(nan, inf)},
	{complex(nan, -1), complex(zero, 1), complex(nan, nan)},
	{complex(nan, -1), complex(-zero, -1), complex(nan, nan)},
	{complex(nan, -1), complex(zero, 2), complex(nan, nan)},
	{complex(nan, -1), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -1), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -1), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -1), complex(1, zero), complex(nan, nan)},
	{complex(nan, -1), complex(1, -zero), complex(nan, nan)},
	{complex(nan, -1), complex(1, 1), complex(nan, nan)},
	{complex(nan, -1), complex(1, -1), complex(nan, nan)},
	{complex(nan, -1), complex(1, 2), complex(nan, nan)},
	{complex(nan, -1), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -1), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -1), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -1), complex(-1, zero), complex(nan, nan)},
	{complex(nan, -1), complex(-1, -zero), complex(nan, nan)},
	{complex(nan, -1), complex(-1, 1), complex(nan, nan)},
	{complex(nan, -1), complex(-1, -1), complex(nan, nan)},
	{complex(nan, -1), complex(-1, 2), complex(nan, nan)},
	{complex(nan, -1), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -1), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -1), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -1), complex(2, zero), complex(nan, nan)},
	{complex(nan, -1), complex(2, -zero), complex(nan, nan)},
	{complex(nan, -1), complex(2, 1), complex(nan, nan)},
	{complex(nan, -1), complex(2, -1), complex(nan, nan)},
	{complex(nan, -1), complex(2, 2), complex(nan, nan)},
	{complex(nan, -1), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -1), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -1), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -1), complex(nan, zero), complex(nan, nan)},
	{complex(nan, -1), complex(nan, -zero), complex(nan, nan)},
	{complex(nan, -1), complex(nan, 1), complex(nan, nan)},
	{complex(nan, -1), complex(nan, -1), complex(nan, nan)},
	{complex(nan, -1), complex(nan, 2), complex(nan, nan)},
	{complex(nan, -1), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -1), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -1), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -1), complex(inf, zero), complex(nan, nan)},
	{complex(nan, -1), complex(inf, -zero), complex(nan, nan)},
	{complex(nan, -1), complex(inf, 1), complex(nan, nan)},
	{complex(nan, -1), complex(inf, -1), complex(nan, nan)},
	{complex(nan, -1), complex(inf, 2), complex(nan, nan)},
	{complex(nan, -1), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -1), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -1), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -1), complex(-inf, zero), complex(nan, nan)},
	{complex(nan, -1), complex(-inf, -zero), complex(nan, nan)},
	{complex(nan, -1), complex(-inf, 1), complex(nan, nan)},
	{complex(nan, -1), complex(-inf, -1), complex(nan, nan)},
	{complex(nan, -1), complex(-inf, 2), complex(nan, nan)},
	{complex(nan, -1), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -1), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -1), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, 2), complex(zero, zero), complex(nan, inf)},
	{complex(nan, 2), complex(zero, -zero), complex(nan, inf)},
	{complex(nan, 2), complex(zero, 1), complex(nan, nan)},
	{complex(nan, 2), complex(zero, -1), complex(nan, nan)},
	{complex(nan, 2), complex(zero, 2), complex(nan, nan)},
	{complex(nan, 2), complex(nan, nan), complex(nan, nan)},
	{complex(nan, 2), complex(nan, inf), complex(nan, nan)},
	{complex(nan, 2), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, 2), complex(zero, zero), complex(nan, inf)},
	{complex(nan, 2), complex(-zero, -zero), complex(nan, -inf)},
	{complex(nan, 2), complex(zero, 1), complex(nan, nan)},
	{complex(nan, 2), complex(-zero, -1), complex(nan, nan)},
	{complex(nan, 2), complex(zero, 2), complex(nan, nan)},
	{complex(nan, 2), complex(nan, nan), complex(nan, nan)},
	{complex(nan, 2), complex(nan, inf), complex(nan, nan)},
	{complex(nan, 2), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, 2), complex(1, zero), complex(nan, nan)},
	{complex(nan, 2), complex(1, -zero), complex(nan, nan)},
	{complex(nan, 2), complex(1, 1), complex(nan, nan)},
	{complex(nan, 2), complex(1, -1), complex(nan, nan)},
	{complex(nan, 2), complex(1, 2), complex(nan, nan)},
	{complex(nan, 2), complex(nan, nan), complex(nan, nan)},
	{complex(nan, 2), complex(nan, inf), complex(nan, nan)},
	{complex(nan, 2), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, 2), complex(-1, zero), complex(nan, nan)},
	{complex(nan, 2), complex(-1, -zero), complex(nan, nan)},
	{complex(nan, 2), complex(-1, 1), complex(nan, nan)},
	{complex(nan, 2), complex(-1, -1), complex(nan, nan)},
	{complex(nan, 2), complex(-1, 2), complex(nan, nan)},
	{complex(nan, 2), complex(nan, nan), complex(nan, nan)},
	{complex(nan, 2), complex(nan, inf), complex(nan, nan)},
	{complex(nan, 2), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, 2), complex(2, zero), complex(nan, nan)},
	{complex(nan, 2), complex(2, -zero), complex(nan, nan)},
	{complex(nan, 2), complex(2, 1), complex(nan, nan)},
	{complex(nan, 2), complex(2, -1), complex(nan, nan)},
	{complex(nan, 2), complex(2, 2), complex(nan, nan)},
	{complex(nan, 2), complex(nan, nan), complex(nan, nan)},
	{complex(nan, 2), complex(nan, inf), complex(nan, nan)},
	{complex(nan, 2), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, 2), complex(nan, zero), complex(nan, nan)},
	{complex(nan, 2), complex(nan, -zero), complex(nan, nan)},
	{complex(nan, 2), complex(nan, 1), complex(nan, nan)},
	{complex(nan, 2), complex(nan, -1), complex(nan, nan)},
	{complex(nan, 2), complex(nan, 2), complex(nan, nan)},
	{complex(nan, 2), complex(nan, nan), complex(nan, nan)},
	{complex(nan, 2), complex(nan, inf), complex(nan, nan)},
	{complex(nan, 2), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, 2), complex(inf, zero), complex(nan, nan)},
	{complex(nan, 2), complex(inf, -zero), complex(nan, nan)},
	{complex(nan, 2), complex(inf, 1), complex(nan, nan)},
	{complex(nan, 2), complex(inf, -1), complex(nan, nan)},
	{complex(nan, 2), complex(inf, 2), complex(nan, nan)},
	{complex(nan, 2), complex(nan, nan), complex(nan, nan)},
	{complex(nan, 2), complex(nan, inf), complex(nan, nan)},
	{complex(nan, 2), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, 2), complex(-inf, zero), complex(nan, nan)},
	{complex(nan, 2), complex(-inf, -zero), complex(nan, nan)},
	{complex(nan, 2), complex(-inf, 1), complex(nan, nan)},
	{complex(nan, 2), complex(-inf, -1), complex(nan, nan)},
	{complex(nan, 2), complex(-inf, 2), complex(nan, nan)},
	{complex(nan, 2), complex(nan, nan), complex(nan, nan)},
	{complex(nan, 2), complex(nan, inf), complex(nan, nan)},
	{complex(nan, 2), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(zero, zero), complex(nan, nan)},
	{complex(nan, nan), complex(zero, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(zero, 1), complex(nan, nan)},
	{complex(nan, nan), complex(zero, -1), complex(nan, nan)},
	{complex(nan, nan), complex(zero, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(zero, zero), complex(nan, nan)},
	{complex(nan, nan), complex(-zero, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(zero, 1), complex(nan, nan)},
	{complex(nan, nan), complex(-zero, -1), complex(nan, nan)},
	{complex(nan, nan), complex(zero, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(1, zero), complex(nan, nan)},
	{complex(nan, nan), complex(1, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(1, 1), complex(nan, nan)},
	{complex(nan, nan), complex(1, -1), complex(nan, nan)},
	{complex(nan, nan), complex(1, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(-1, zero), complex(nan, nan)},
	{complex(nan, nan), complex(-1, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(-1, 1), complex(nan, nan)},
	{complex(nan, nan), complex(-1, -1), complex(nan, nan)},
	{complex(nan, nan), complex(-1, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(2, zero), complex(nan, nan)},
	{complex(nan, nan), complex(2, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(2, 1), complex(nan, nan)},
	{complex(nan, nan), complex(2, -1), complex(nan, nan)},
	{complex(nan, nan), complex(2, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, zero), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(nan, 1), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -1), complex(nan, nan)},
	{complex(nan, nan), complex(nan, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(inf, zero), complex(nan, nan)},
	{complex(nan, nan), complex(inf, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(inf, 1), complex(nan, nan)},
	{complex(nan, nan), complex(inf, -1), complex(nan, nan)},
	{complex(nan, nan), complex(inf, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, zero), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, 1), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, -1), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(zero, zero), complex(nan, inf)},
	{complex(nan, inf), complex(zero, -zero), complex(nan, inf)},
	{complex(nan, inf), complex(zero, 1), complex(inf, nan)},
	{complex(nan, inf), complex(zero, -1), complex(-inf, nan)},
	{complex(nan, inf), complex(zero, 2), complex(inf, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(zero, zero), complex(nan, inf)},
	{complex(nan, inf), complex(-zero, -zero), complex(nan, -inf)},
	{complex(nan, inf), complex(zero, 1), complex(inf, nan)},
	{complex(nan, inf), complex(-zero, -1), complex(-inf, nan)},
	{complex(nan, inf), complex(zero, 2), complex(inf, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(1, zero), complex(nan, inf)},
	{complex(nan, inf), complex(1, -zero), complex(nan, inf)},
	{complex(nan, inf), complex(1, 1), complex(inf, inf)},
	{complex(nan, inf), complex(1, -1), complex(-inf, inf)},
	{complex(nan, inf), complex(1, 2), complex(inf, inf)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(-1, zero), complex(nan, -inf)},
	{complex(nan, inf), complex(-1, -zero), complex(nan, -inf)},
	{complex(nan, inf), complex(-1, 1), complex(inf, -inf)},
	{complex(nan, inf), complex(-1, -1), complex(-inf, -inf)},
	{complex(nan, inf), complex(-1, 2), complex(inf, -inf)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(2, zero), complex(nan, inf)},
	{complex(nan, inf), complex(2, -zero), complex(nan, inf)},
	{complex(nan, inf), complex(2, 1), complex(inf, inf)},
	{complex(nan, inf), complex(2, -1), complex(-inf, inf)},
	{complex(nan, inf), complex(2, 2), complex(inf, inf)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, zero), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -zero), complex(nan, nan)},
	{complex(nan, inf), complex(nan, 1), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -1), complex(nan, nan)},
	{complex(nan, inf), complex(nan, 2), complex(nan, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(inf, zero), complex(nan, nan)},
	{complex(nan, inf), complex(inf, -zero), complex(nan, nan)},
	{complex(nan, inf), complex(inf, 1), complex(nan, nan)},
	{complex(nan, inf), complex(inf, -1), complex(nan, nan)},
	{complex(nan, inf), complex(inf, 2), complex(nan, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, zero), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, -zero), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, 1), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, -1), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, 2), complex(nan, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(zero, zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(zero, -zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(zero, 1), complex(-inf, nan)},
	{complex(nan, -inf), complex(zero, -1), complex(inf, nan)},
	{complex(nan, -inf), complex(zero, 2), complex(-inf, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(zero, zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(-zero, -zero), complex(nan, inf)},
	{complex(nan, -inf), complex(zero, 1), complex(-inf, nan)},
	{complex(nan, -inf), complex(-zero, -1), complex(inf, nan)},
	{complex(nan, -inf), complex(zero, 2), complex(-inf, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(1, zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(1, -zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(1, 1), complex(-inf, -inf)},
	{complex(nan, -inf), complex(1, -1), complex(inf, -inf)},
	{complex(nan, -inf), complex(1, 2), complex(-inf, -inf)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(-1, zero), complex(nan, inf)},
	{complex(nan, -inf), complex(-1, -zero), complex(nan, inf)},
	{complex(nan, -inf), complex(-1, 1), complex(-inf, inf)},
	{complex(nan, -inf), complex(-1, -1), complex(inf, inf)},
	{complex(nan, -inf), complex(-1, 2), complex(-inf, inf)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(2, zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(2, -zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(2, 1), complex(-inf, -inf)},
	{complex(nan, -inf), complex(2, -1), complex(inf, -inf)},
	{complex(nan, -inf), complex(2, 2), complex(-inf, -inf)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, zero), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -zero), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, 1), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -1), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, 2), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, zero), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, -zero), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, 1), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, -1), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, 2), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, zero), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, -zero), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, 1), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, -1), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, 2), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, zero), complex(zero, zero), complex(inf, nan)},
	{complex(inf, zero), complex(zero, -zero), complex(inf, nan)},
	{complex(inf, zero), complex(zero, 1), complex(nan, -inf)},
	{complex(inf, zero), complex(zero, -1), complex(nan, inf)},
	{complex(inf, zero), complex(zero, 2), complex(nan, -inf)},
	{complex(inf, zero), complex(nan, nan), complex(nan, nan)},
	{complex(inf, zero), complex(nan, inf), complex(nan, nan)},
	{complex(inf, zero), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, zero), complex(zero, zero), complex(inf, nan)},
	{complex(inf, zero), complex(-zero, -zero), complex(-inf, nan)},
	{complex(inf, zero), complex(zero, 1), complex(nan, -inf)},
	{complex(inf, zero), complex(-zero, -1), complex(nan, inf)},
	{complex(inf, zero), complex(zero, 2), complex(nan, -inf)},
	{complex(inf, zero), complex(nan, nan), complex(nan, nan)},
	{complex(inf, zero), complex(nan, inf), complex(nan, nan)},
	{complex(inf, zero), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, zero), complex(1, zero), complex(inf, nan)},
	{complex(inf, zero), complex(1, -zero), complex(inf, nan)},
	{complex(inf, zero), complex(1, 1), complex(inf, -inf)},
	{complex(inf, zero), complex(1, -1), complex(inf, inf)},
	{complex(inf, zero), complex(1, 2), complex(inf, -inf)},
	{complex(inf, zero), complex(nan, nan), complex(nan, nan)},
	{complex(inf, zero), complex(nan, inf), complex(nan, nan)},
	{complex(inf, zero), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, zero), complex(-1, zero), complex(-inf, nan)},
	{complex(inf, zero), complex(-1, -zero), complex(-inf, nan)},
	{complex(inf, zero), complex(-1, 1), complex(-inf, -inf)},
	{complex(inf, zero), complex(-1, -1), complex(-inf, inf)},
	{complex(inf, zero), complex(-1, 2), complex(-inf, -inf)},
	{complex(inf, zero), complex(nan, nan), complex(nan, nan)},
	{complex(inf, zero), complex(nan, inf), complex(nan, nan)},
	{complex(inf, zero), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, zero), complex(2, zero), complex(inf, nan)},
	{complex(inf, zero), complex(2, -zero), complex(inf, nan)},
	{complex(inf, zero), complex(2, 1), complex(inf, -inf)},
	{complex(inf, zero), complex(2, -1), complex(inf, inf)},
	{complex(inf, zero), complex(2, 2), complex(inf, -inf)},
	{complex(inf, zero), complex(nan, nan), complex(nan, nan)},
	{complex(inf, zero), complex(nan, inf), complex(nan, nan)},
	{complex(inf, zero), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, zero), complex(nan, zero), complex(nan, nan)},
	{complex(inf, zero), complex(nan, -zero), complex(nan, nan)},
	{complex(inf, zero), complex(nan, 1), complex(nan, nan)},
	{complex(inf, zero), complex(nan, -1), complex(nan, nan)},
	{complex(inf, zero), complex(nan, 2), complex(nan, nan)},
	{complex(inf, zero), complex(nan, nan), complex(nan, nan)},
	{complex(inf, zero), complex(nan, inf), complex(nan, nan)},
	{complex(inf, zero), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, zero), complex(inf, zero), complex(nan, nan)},
	{complex(inf, zero), complex(inf, -zero), complex(nan, nan)},
	{complex(inf, zero), complex(inf, 1), complex(nan, nan)},
	{complex(inf, zero), complex(inf, -1), complex(nan, nan)},
	{complex(inf, zero), complex(inf, 2), complex(nan, nan)},
	{complex(inf, zero), complex(nan, nan), complex(nan, nan)},
	{complex(inf, zero), complex(nan, inf), complex(nan, nan)},
	{complex(inf, zero), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, zero), complex(-inf, zero), complex(nan, nan)},
	{complex(inf, zero), complex(-inf, -zero), complex(nan, nan)},
	{complex(inf, zero), complex(-inf, 1), complex(nan, nan)},
	{complex(inf, zero), complex(-inf, -1), complex(nan, nan)},
	{complex(inf, zero), complex(-inf, 2), complex(nan, nan)},
	{complex(inf, zero), complex(nan, nan), complex(nan, nan)},
	{complex(inf, zero), complex(nan, inf), complex(nan, nan)},
	{complex(inf, zero), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, -zero), complex(zero, zero), complex(inf, nan)},
	{complex(inf, -zero), complex(zero, -zero), complex(inf, nan)},
	{complex(inf, -zero), complex(zero, 1), complex(nan, -inf)},
	{complex(inf, -zero), complex(zero, -1), complex(nan, inf)},
	{complex(inf, -zero), complex(zero, 2), complex(nan, -inf)},
	{complex(inf, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(inf, -zero), complex(nan, inf), complex(nan, nan)},
	{complex(inf, -zero), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, -zero), complex(zero, zero), complex(inf, nan)},
	{complex(inf, -zero), complex(-zero, -zero), complex(-inf, nan)},
	{complex(inf, -zero), complex(zero, 1), complex(nan, -inf)},
	{complex(inf, -zero), complex(-zero, -1), complex(nan, inf)},
	{complex(inf, -zero), complex(zero, 2), complex(nan, -inf)},
	{complex(inf, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(inf, -zero), complex(nan, inf), complex(nan, nan)},
	{complex(inf, -zero), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, -zero), complex(1, zero), complex(inf, nan)},
	{complex(inf, -zero), complex(1, -zero), complex(inf, nan)},
	{complex(inf, -zero), complex(1, 1), complex(inf, -inf)},
	{complex(inf, -zero), complex(1, -1), complex(inf, inf)},
	{complex(inf, -zero), complex(1, 2), complex(inf, -inf)},
	{complex(inf, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(inf, -zero), complex(nan, inf), complex(nan, nan)},
	{complex(inf, -zero), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, -zero), complex(-1, zero), complex(-inf, nan)},
	{complex(inf, -zero), complex(-1, -zero), complex(-inf, nan)},
	{complex(inf, -zero), complex(-1, 1), complex(-inf, -inf)},
	{complex(inf, -zero), complex(-1, -1), complex(-inf, inf)},
	{complex(inf, -zero), complex(-1, 2), complex(-inf, -inf)},
	{complex(inf, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(inf, -zero), complex(nan, inf), complex(nan, nan)},
	{complex(inf, -zero), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, -zero), complex(2, zero), complex(inf, nan)},
	{complex(inf, -zero), complex(2, -zero), complex(inf, nan)},
	{complex(inf, -zero), complex(2, 1), complex(inf, -inf)},
	{complex(inf, -zero), complex(2, -1), complex(inf, inf)},
	{complex(inf, -zero), complex(2, 2), complex(inf, -inf)},
	{complex(inf, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(inf, -zero), complex(nan, inf), complex(nan, nan)},
	{complex(inf, -zero), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, -zero), complex(nan, zero), complex(nan, nan)},
	{complex(inf, -zero), complex(nan, -zero), complex(nan, nan)},
	{complex(inf, -zero), complex(nan, 1), complex(nan, nan)},
	{complex(inf, -zero), complex(nan, -1), complex(nan, nan)},
	{complex(inf, -zero), complex(nan, 2), complex(nan, nan)},
	{complex(inf, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(inf, -zero), complex(nan, inf), complex(nan, nan)},
	{complex(inf, -zero), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, -zero), complex(inf, zero), complex(nan, nan)},
	{complex(inf, -zero), complex(inf, -zero), complex(nan, nan)},
	{complex(inf, -zero), complex(inf, 1), complex(nan, nan)},
	{complex(inf, -zero), complex(inf, -1), complex(nan, nan)},
	{complex(inf, -zero), complex(inf, 2), complex(nan, nan)},
	{complex(inf, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(inf, -zero), complex(nan, inf), complex(nan, nan)},
	{complex(inf, -zero), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, -zero), complex(-inf, zero), complex(nan, nan)},
	{complex(inf, -zero), complex(-inf, -zero), complex(nan, nan)},
	{complex(inf, -zero), complex(-inf, 1), complex(nan, nan)},
	{complex(inf, -zero), complex(-inf, -1), complex(nan, nan)},
	{complex(inf, -zero), complex(-inf, 2), complex(nan, nan)},
	{complex(inf, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(inf, -zero), complex(nan, inf), complex(nan, nan)},
	{complex(inf, -zero), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, 1), complex(zero, zero), complex(inf, inf)},
	{complex(inf, 1), complex(zero, -zero), complex(inf, inf)},
	{complex(inf, 1), complex(zero, 1), complex(nan, -inf)},
	{complex(inf, 1), complex(zero, -1), complex(nan, inf)},
	{complex(inf, 1), complex(zero, 2), complex(nan, -inf)},
	{complex(inf, 1), complex(nan, nan), complex(nan, nan)},
	{complex(inf, 1), complex(nan, inf), complex(nan, nan)},
	{complex(inf, 1), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, 1), complex(zero, zero), complex(inf, inf)},
	{complex(inf, 1), complex(-zero, -zero), complex(-inf, -inf)},
	{complex(inf, 1), complex(zero, 1), complex(nan, -inf)},
	{complex(inf, 1), complex(-zero, -1), complex(nan, inf)},
	{complex(inf, 1), complex(zero, 2), complex(nan, -inf)},
	{complex(inf, 1), complex(nan, nan), complex(nan, nan)},
	{complex(inf, 1), complex(nan, inf), complex(nan, nan)},
	{complex(inf, 1), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, 1), complex(1, zero), complex(inf, nan)},
	{complex(inf, 1), complex(1, -zero), complex(inf, nan)},
	{complex(inf, 1), complex(1, 1), complex(inf, -inf)},
	{complex(inf, 1), complex(1, -1), complex(inf, inf)},
	{complex(inf, 1), complex(1, 2), complex(inf, -inf)},
	{complex(inf, 1), complex(nan, nan), complex(nan, nan)},
	{complex(inf, 1), complex(nan, inf), complex(nan, nan)},
	{complex(inf, 1), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, 1), complex(-1, zero), complex(-inf, nan)},
	{complex(inf, 1), complex(-1, -zero), complex(-inf, nan)},
	{complex(inf, 1), complex(-1, 1), complex(-inf, -inf)},
	{complex(inf, 1), complex(-1, -1), complex(-inf, inf)},
	{complex(inf, 1), complex(-1, 2), complex(-inf, -inf)},
	{complex(inf, 1), complex(nan, nan), complex(nan, nan)},
	{complex(inf, 1), complex(nan, inf), complex(nan, nan)},
	{complex(inf, 1), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, 1), complex(2, zero), complex(inf, nan)},
	{complex(inf, 1), complex(2, -zero), complex(inf, nan)},
	{complex(inf, 1), complex(2, 1), complex(inf, -inf)},
	{complex(inf, 1), complex(2, -1), complex(inf, inf)},
	{complex(inf, 1), complex(2, 2), complex(inf, -inf)},
	{complex(inf, 1), complex(nan, nan), complex(nan, nan)},
	{complex(inf, 1), complex(nan, inf), complex(nan, nan)},
	{complex(inf, 1), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, 1), complex(nan, zero), complex(nan, nan)},
	{complex(inf, 1), complex(nan, -zero), complex(nan, nan)},
	{complex(inf, 1), complex(nan, 1), complex(nan, nan)},
	{complex(inf, 1), complex(nan, -1), complex(nan, nan)},
	{complex(inf, 1), complex(nan, 2), complex(nan, nan)},
	{complex(inf, 1), complex(nan, nan), complex(nan, nan)},
	{complex(inf, 1), complex(nan, inf), complex(nan, nan)},
	{complex(inf, 1), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, 1), complex(inf, zero), complex(nan, nan)},
	{complex(inf, 1), complex(inf, -zero), complex(nan, nan)},
	{complex(inf, 1), complex(inf, 1), complex(nan, nan)},
	{complex(inf, 1), complex(inf, -1), complex(nan, nan)},
	{complex(inf, 1), complex(inf, 2), complex(nan, nan)},
	{complex(inf, 1), complex(nan, nan), complex(nan, nan)},
	{complex(inf, 1), complex(nan, inf), complex(nan, nan)},
	{complex(inf, 1), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, 1), complex(-inf, zero), complex(nan, nan)},
	{complex(inf, 1), complex(-inf, -zero), complex(nan, nan)},
	{complex(inf, 1), complex(-inf, 1), complex(nan, nan)},
	{complex(inf, 1), complex(-inf, -1), complex(nan, nan)},
	{complex(inf, 1), complex(-inf, 2), complex(nan, nan)},
	{complex(inf, 1), complex(nan, nan), complex(nan, nan)},
	{complex(inf, 1), complex(nan, inf), complex(nan, nan)},
	{complex(inf, 1), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, -1), complex(zero, zero), complex(inf, -inf)},
	{complex(inf, -1), complex(zero, -zero), complex(inf, -inf)},
	{complex(inf, -1), complex(zero, 1), complex(nan, -inf)},
	{complex(inf, -1), complex(zero, -1), complex(nan, inf)},
	{complex(inf, -1), complex(zero, 2), complex(nan, -inf)},
	{complex(inf, -1), complex(nan, nan), complex(nan, nan)},
	{complex(inf, -1), complex(nan, inf), complex(nan, nan)},
	{complex(inf, -1), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, -1), complex(zero, zero), complex(inf, -inf)},
	{complex(inf, -1), complex(-zero, -zero), complex(-inf, inf)},
	{complex(inf, -1), complex(zero, 1), complex(nan, -inf)},
	{complex(inf, -1), complex(-zero, -1), complex(nan, inf)},
	{complex(inf, -1), complex(zero, 2), complex(nan, -inf)},
	{complex(inf, -1), complex(nan, nan), complex(nan, nan)},
	{complex(inf, -1), complex(nan, inf), complex(nan, nan)},
	{complex(inf, -1), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, -1), complex(1, zero), complex(inf, nan)},
	{complex(inf, -1), complex(1, -zero), complex(inf, nan)},
	{complex(inf, -1), complex(1, 1), complex(inf, -inf)},
	{complex(inf, -1), complex(1, -1), complex(inf, inf)},
	{complex(inf, -1), complex(1, 2), complex(inf, -inf)},
	{complex(inf, -1), complex(nan, nan), complex(nan, nan)},
	{complex(inf, -1), complex(nan, inf), complex(nan, nan)},
	{complex(inf, -1), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, -1), complex(-1, zero), complex(-inf, nan)},
	{complex(inf, -1), complex(-1, -zero), complex(-inf, nan)},
	{complex(inf, -1), complex(-1, 1), complex(-inf, -inf)},
	{complex(inf, -1), complex(-1, -1), complex(-inf, inf)},
	{complex(inf, -1), complex(-1, 2), complex(-inf, -inf)},
	{complex(inf, -1), complex(nan, nan), complex(nan, nan)},
	{complex(inf, -1), complex(nan, inf), complex(nan, nan)},
	{complex(inf, -1), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, -1), complex(2, zero), complex(inf, nan)},
	{complex(inf, -1), complex(2, -zero), complex(inf, nan)},
	{complex(inf, -1), complex(2, 1), complex(inf, -inf)},
	{complex(inf, -1), complex(2, -1), complex(inf, inf)},
	{complex(inf, -1), complex(2, 2), complex(inf, -inf)},
	{complex(inf, -1), complex(nan, nan), complex(nan, nan)},
	{complex(inf, -1), complex(nan, inf), complex(nan, nan)},
	{complex(inf, -1), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, -1), complex(nan, zero), complex(nan, nan)},
	{complex(inf, -1), complex(nan, -zero), complex(nan, nan)},
	{complex(inf, -1), complex(nan, 1), complex(nan, nan)},
	{complex(inf, -1), complex(nan, -1), complex(nan, nan)},
	{complex(inf, -1), complex(nan, 2), complex(nan, nan)},
	{complex(inf, -1), complex(nan, nan), complex(nan, nan)},
	{complex(inf, -1), complex(nan, inf), complex(nan, nan)},
	{complex(inf, -1), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, -1), complex(inf, zero), complex(nan, nan)},
	{complex(inf, -1), complex(inf, -zero), complex(nan, nan)},
	{complex(inf, -1), complex(inf, 1), complex(nan, nan)},
	{complex(inf, -1), complex(inf, -1), complex(nan, nan)},
	{complex(inf, -1), complex(inf, 2), complex(nan, nan)},
	{complex(inf, -1), complex(nan, nan), complex(nan, nan)},
	{complex(inf, -1), complex(nan, inf), complex(nan, nan)},
	{complex(inf, -1), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, -1), complex(-inf, zero), complex(nan, nan)},
	{complex(inf, -1), complex(-inf, -zero), complex(nan, nan)},
	{complex(inf, -1), complex(-inf, 1), complex(nan, nan)},
	{complex(inf, -1), complex(-inf, -1), complex(nan, nan)},
	{complex(inf, -1), complex(-inf, 2), complex(nan, nan)},
	{complex(inf, -1), complex(nan, nan), complex(nan, nan)},
	{complex(inf, -1), complex(nan, inf), complex(nan, nan)},
	{complex(inf, -1), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, 2), complex(zero, zero), complex(inf, inf)},
	{complex(inf, 2), complex(zero, -zero), complex(inf, inf)},
	{complex(inf, 2), complex(zero, 1), complex(nan, -inf)},
	{complex(inf, 2), complex(zero, -1), complex(nan, inf)},
	{complex(inf, 2), complex(zero, 2), complex(nan, -inf)},
	{complex(inf, 2), complex(nan, nan), complex(nan, nan)},
	{complex(inf, 2), complex(nan, inf), complex(nan, nan)},
	{complex(inf, 2), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, 2), complex(zero, zero), complex(inf, inf)},
	{complex(inf, 2), complex(-zero, -zero), complex(-inf, -inf)},
	{complex(inf, 2), complex(zero, 1), complex(nan, -inf)},
	{complex(inf, 2), complex(-zero, -1), complex(nan, inf)},
	{complex(inf, 2), complex(zero, 2), complex(nan, -inf)},
	{complex(inf, 2), complex(nan, nan), complex(nan, nan)},
	{complex(inf, 2), complex(nan, inf), complex(nan, nan)},
	{complex(inf, 2), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, 2), complex(1, zero), complex(inf, nan)},
	{complex(inf, 2), complex(1, -zero), complex(inf, nan)},
	{complex(inf, 2), complex(1, 1), complex(inf, -inf)},
	{complex(inf, 2), complex(1, -1), complex(inf, inf)},
	{complex(inf, 2), complex(1, 2), complex(inf, -inf)},
	{complex(inf, 2), complex(nan, nan), complex(nan, nan)},
	{complex(inf, 2), complex(nan, inf), complex(nan, nan)},
	{complex(inf, 2), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, 2), complex(-1, zero), complex(-inf, nan)},
	{complex(inf, 2), complex(-1, -zero), complex(-inf, nan)},
	{complex(inf, 2), complex(-1, 1), complex(-inf, -inf)},
	{complex(inf, 2), complex(-1, -1), complex(-inf, inf)},
	{complex(inf, 2), complex(-1, 2), complex(-inf, -inf)},
	{complex(inf, 2), complex(nan, nan), complex(nan, nan)},
	{complex(inf, 2), complex(nan, inf), complex(nan, nan)},
	{complex(inf, 2), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, 2), complex(2, zero), complex(inf, nan)},
	{complex(inf, 2), complex(2, -zero), complex(inf, nan)},
	{complex(inf, 2), complex(2, 1), complex(inf, -inf)},
	{complex(inf, 2), complex(2, -1), complex(inf, inf)},
	{complex(inf, 2), complex(2, 2), complex(inf, -inf)},
	{complex(inf, 2), complex(nan, nan), complex(nan, nan)},
	{complex(inf, 2), complex(nan, inf), complex(nan, nan)},
	{complex(inf, 2), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, 2), complex(nan, zero), complex(nan, nan)},
	{complex(inf, 2), complex(nan, -zero), complex(nan, nan)},
	{complex(inf, 2), complex(nan, 1), complex(nan, nan)},
	{complex(inf, 2), complex(nan, -1), complex(nan, nan)},
	{complex(inf, 2), complex(nan, 2), complex(nan, nan)},
	{complex(inf, 2), complex(nan, nan), complex(nan, nan)},
	{complex(inf, 2), complex(nan, inf), complex(nan, nan)},
	{complex(inf, 2), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, 2), complex(inf, zero), complex(nan, nan)},
	{complex(inf, 2), complex(inf, -zero), complex(nan, nan)},
	{complex(inf, 2), complex(inf, 1), complex(nan, nan)},
	{complex(inf, 2), complex(inf, -1), complex(nan, nan)},
	{complex(inf, 2), complex(inf, 2), complex(nan, nan)},
	{complex(inf, 2), complex(nan, nan), complex(nan, nan)},
	{complex(inf, 2), complex(nan, inf), complex(nan, nan)},
	{complex(inf, 2), complex(nan, -inf), complex(nan, nan)},
	{complex(inf, 2), complex(-inf, zero), complex(nan, nan)},
	{complex(inf, 2), complex(-inf, -zero), complex(nan, nan)},
	{complex(inf, 2), complex(-inf, 1), complex(nan, nan)},
	{complex(inf, 2), complex(-inf, -1), complex(nan, nan)},
	{complex(inf, 2), complex(-inf, 2), complex(nan, nan)},
	{complex(inf, 2), complex(nan, nan), complex(nan, nan)},
	{complex(inf, 2), complex(nan, inf), complex(nan, nan)},
	{complex(inf, 2), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(zero, zero), complex(nan, nan)},
	{complex(nan, nan), complex(zero, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(zero, 1), complex(nan, nan)},
	{complex(nan, nan), complex(zero, -1), complex(nan, nan)},
	{complex(nan, nan), complex(zero, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(zero, zero), complex(nan, nan)},
	{complex(nan, nan), complex(-zero, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(zero, 1), complex(nan, nan)},
	{complex(nan, nan), complex(-zero, -1), complex(nan, nan)},
	{complex(nan, nan), complex(zero, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(1, zero), complex(nan, nan)},
	{complex(nan, nan), complex(1, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(1, 1), complex(nan, nan)},
	{complex(nan, nan), complex(1, -1), complex(nan, nan)},
	{complex(nan, nan), complex(1, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(-1, zero), complex(nan, nan)},
	{complex(nan, nan), complex(-1, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(-1, 1), complex(nan, nan)},
	{complex(nan, nan), complex(-1, -1), complex(nan, nan)},
	{complex(nan, nan), complex(-1, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(2, zero), complex(nan, nan)},
	{complex(nan, nan), complex(2, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(2, 1), complex(nan, nan)},
	{complex(nan, nan), complex(2, -1), complex(nan, nan)},
	{complex(nan, nan), complex(2, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, zero), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(nan, 1), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -1), complex(nan, nan)},
	{complex(nan, nan), complex(nan, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(inf, zero), complex(nan, nan)},
	{complex(nan, nan), complex(inf, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(inf, 1), complex(nan, nan)},
	{complex(nan, nan), complex(inf, -1), complex(nan, nan)},
	{complex(nan, nan), complex(inf, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, zero), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, 1), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, -1), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(zero, zero), complex(nan, inf)},
	{complex(nan, inf), complex(zero, -zero), complex(nan, inf)},
	{complex(nan, inf), complex(zero, 1), complex(inf, nan)},
	{complex(nan, inf), complex(zero, -1), complex(-inf, nan)},
	{complex(nan, inf), complex(zero, 2), complex(inf, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(zero, zero), complex(nan, inf)},
	{complex(nan, inf), complex(-zero, -zero), complex(nan, -inf)},
	{complex(nan, inf), complex(zero, 1), complex(inf, nan)},
	{complex(nan, inf), complex(-zero, -1), complex(-inf, nan)},
	{complex(nan, inf), complex(zero, 2), complex(inf, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(1, zero), complex(nan, inf)},
	{complex(nan, inf), complex(1, -zero), complex(nan, inf)},
	{complex(nan, inf), complex(1, 1), complex(inf, inf)},
	{complex(nan, inf), complex(1, -1), complex(-inf, inf)},
	{complex(nan, inf), complex(1, 2), complex(inf, inf)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(-1, zero), complex(nan, -inf)},
	{complex(nan, inf), complex(-1, -zero), complex(nan, -inf)},
	{complex(nan, inf), complex(-1, 1), complex(inf, -inf)},
	{complex(nan, inf), complex(-1, -1), complex(-inf, -inf)},
	{complex(nan, inf), complex(-1, 2), complex(inf, -inf)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(2, zero), complex(nan, inf)},
	{complex(nan, inf), complex(2, -zero), complex(nan, inf)},
	{complex(nan, inf), complex(2, 1), complex(inf, inf)},
	{complex(nan, inf), complex(2, -1), complex(-inf, inf)},
	{complex(nan, inf), complex(2, 2), complex(inf, inf)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, zero), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -zero), complex(nan, nan)},
	{complex(nan, inf), complex(nan, 1), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -1), complex(nan, nan)},
	{complex(nan, inf), complex(nan, 2), complex(nan, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(inf, zero), complex(nan, nan)},
	{complex(nan, inf), complex(inf, -zero), complex(nan, nan)},
	{complex(nan, inf), complex(inf, 1), complex(nan, nan)},
	{complex(nan, inf), complex(inf, -1), complex(nan, nan)},
	{complex(nan, inf), complex(inf, 2), complex(nan, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, zero), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, -zero), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, 1), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, -1), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, 2), complex(nan, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(zero, zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(zero, -zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(zero, 1), complex(-inf, nan)},
	{complex(nan, -inf), complex(zero, -1), complex(inf, nan)},
	{complex(nan, -inf), complex(zero, 2), complex(-inf, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(zero, zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(-zero, -zero), complex(nan, inf)},
	{complex(nan, -inf), complex(zero, 1), complex(-inf, nan)},
	{complex(nan, -inf), complex(-zero, -1), complex(inf, nan)},
	{complex(nan, -inf), complex(zero, 2), complex(-inf, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(1, zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(1, -zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(1, 1), complex(-inf, -inf)},
	{complex(nan, -inf), complex(1, -1), complex(inf, -inf)},
	{complex(nan, -inf), complex(1, 2), complex(-inf, -inf)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(-1, zero), complex(nan, inf)},
	{complex(nan, -inf), complex(-1, -zero), complex(nan, inf)},
	{complex(nan, -inf), complex(-1, 1), complex(-inf, inf)},
	{complex(nan, -inf), complex(-1, -1), complex(inf, inf)},
	{complex(nan, -inf), complex(-1, 2), complex(-inf, inf)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(2, zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(2, -zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(2, 1), complex(-inf, -inf)},
	{complex(nan, -inf), complex(2, -1), complex(inf, -inf)},
	{complex(nan, -inf), complex(2, 2), complex(-inf, -inf)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, zero), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -zero), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, 1), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -1), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, 2), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, zero), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, -zero), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, 1), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, -1), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, 2), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, zero), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, -zero), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, 1), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, -1), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, 2), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, zero), complex(zero, zero), complex(-inf, nan)},
	{complex(-inf, zero), complex(zero, -zero), complex(-inf, nan)},
	{complex(-inf, zero), complex(zero, 1), complex(nan, inf)},
	{complex(-inf, zero), complex(zero, -1), complex(nan, -inf)},
	{complex(-inf, zero), complex(zero, 2), complex(nan, inf)},
	{complex(-inf, zero), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, zero), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, zero), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, zero), complex(zero, zero), complex(-inf, nan)},
	{complex(-inf, zero), complex(-zero, -zero), complex(inf, nan)},
	{complex(-inf, zero), complex(zero, 1), complex(nan, inf)},
	{complex(-inf, zero), complex(-zero, -1), complex(nan, -inf)},
	{complex(-inf, zero), complex(zero, 2), complex(nan, inf)},
	{complex(-inf, zero), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, zero), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, zero), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, zero), complex(1, zero), complex(-inf, nan)},
	{complex(-inf, zero), complex(1, -zero), complex(-inf, nan)},
	{complex(-inf, zero), complex(1, 1), complex(-inf, inf)},
	{complex(-inf, zero), complex(1, -1), complex(-inf, -inf)},
	{complex(-inf, zero), complex(1, 2), complex(-inf, inf)},
	{complex(-inf, zero), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, zero), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, zero), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, zero), complex(-1, zero), complex(inf, nan)},
	{complex(-inf, zero), complex(-1, -zero), complex(inf, nan)},
	{complex(-inf, zero), complex(-1, 1), complex(inf, inf)},
	{complex(-inf, zero), complex(-1, -1), complex(inf, -inf)},
	{complex(-inf, zero), complex(-1, 2), complex(inf, inf)},
	{complex(-inf, zero), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, zero), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, zero), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, zero), complex(2, zero), complex(-inf, nan)},
	{complex(-inf, zero), complex(2, -zero), complex(-inf, nan)},
	{complex(-inf, zero), complex(2, 1), complex(-inf, inf)},
	{complex(-inf, zero), complex(2, -1), complex(-inf, -inf)},
	{complex(-inf, zero), complex(2, 2), complex(-inf, inf)},
	{complex(-inf, zero), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, zero), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, zero), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, zero), complex(nan, zero), complex(nan, nan)},
	{complex(-inf, zero), complex(nan, -zero), complex(nan, nan)},
	{complex(-inf, zero), complex(nan, 1), complex(nan, nan)},
	{complex(-inf, zero), complex(nan, -1), complex(nan, nan)},
	{complex(-inf, zero), complex(nan, 2), complex(nan, nan)},
	{complex(-inf, zero), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, zero), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, zero), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, zero), complex(inf, zero), complex(nan, nan)},
	{complex(-inf, zero), complex(inf, -zero), complex(nan, nan)},
	{complex(-inf, zero), complex(inf, 1), complex(nan, nan)},
	{complex(-inf, zero), complex(inf, -1), complex(nan, nan)},
	{complex(-inf, zero), complex(inf, 2), complex(nan, nan)},
	{complex(-inf, zero), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, zero), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, zero), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, zero), complex(-inf, zero), complex(nan, nan)},
	{complex(-inf, zero), complex(-inf, -zero), complex(nan, nan)},
	{complex(-inf, zero), complex(-inf, 1), complex(nan, nan)},
	{complex(-inf, zero), complex(-inf, -1), complex(nan, nan)},
	{complex(-inf, zero), complex(-inf, 2), complex(nan, nan)},
	{complex(-inf, zero), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, zero), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, zero), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, -zero), complex(zero, zero), complex(-inf, nan)},
	{complex(-inf, -zero), complex(zero, -zero), complex(-inf, nan)},
	{complex(-inf, -zero), complex(zero, 1), complex(nan, inf)},
	{complex(-inf, -zero), complex(zero, -1), complex(nan, -inf)},
	{complex(-inf, -zero), complex(zero, 2), complex(nan, inf)},
	{complex(-inf, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, -zero), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, -zero), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, -zero), complex(zero, zero), complex(-inf, nan)},
	{complex(-inf, -zero), complex(-zero, -zero), complex(inf, nan)},
	{complex(-inf, -zero), complex(zero, 1), complex(nan, inf)},
	{complex(-inf, -zero), complex(-zero, -1), complex(nan, -inf)},
	{complex(-inf, -zero), complex(zero, 2), complex(nan, inf)},
	{complex(-inf, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, -zero), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, -zero), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, -zero), complex(1, zero), complex(-inf, nan)},
	{complex(-inf, -zero), complex(1, -zero), complex(-inf, nan)},
	{complex(-inf, -zero), complex(1, 1), complex(-inf, inf)},
	{complex(-inf, -zero), complex(1, -1), complex(-inf, -inf)},
	{complex(-inf, -zero), complex(1, 2), complex(-inf, inf)},
	{complex(-inf, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, -zero), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, -zero), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, -zero), complex(-1, zero), complex(inf, nan)},
	{complex(-inf, -zero), complex(-1, -zero), complex(inf, nan)},
	{complex(-inf, -zero), complex(-1, 1), complex(inf, inf)},
	{complex(-inf, -zero), complex(-1, -1), complex(inf, -inf)},
	{complex(-inf, -zero), complex(-1, 2), complex(inf, inf)},
	{complex(-inf, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, -zero), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, -zero), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, -zero), complex(2, zero), complex(-inf, nan)},
	{complex(-inf, -zero), complex(2, -zero), complex(-inf, nan)},
	{complex(-inf, -zero), complex(2, 1), complex(-inf, inf)},
	{complex(-inf, -zero), complex(2, -1), complex(-inf, -inf)},
	{complex(-inf, -zero), complex(2, 2), complex(-inf, inf)},
	{complex(-inf, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, -zero), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, -zero), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, -zero), complex(nan, zero), complex(nan, nan)},
	{complex(-inf, -zero), complex(nan, -zero), complex(nan, nan)},
	{complex(-inf, -zero), complex(nan, 1), complex(nan, nan)},
	{complex(-inf, -zero), complex(nan, -1), complex(nan, nan)},
	{complex(-inf, -zero), complex(nan, 2), complex(nan, nan)},
	{complex(-inf, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, -zero), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, -zero), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, -zero), complex(inf, zero), complex(nan, nan)},
	{complex(-inf, -zero), complex(inf, -zero), complex(nan, nan)},
	{complex(-inf, -zero), complex(inf, 1), complex(nan, nan)},
	{complex(-inf, -zero), complex(inf, -1), complex(nan, nan)},
	{complex(-inf, -zero), complex(inf, 2), complex(nan, nan)},
	{complex(-inf, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, -zero), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, -zero), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, -zero), complex(-inf, zero), complex(nan, nan)},
	{complex(-inf, -zero), complex(-inf, -zero), complex(nan, nan)},
	{complex(-inf, -zero), complex(-inf, 1), complex(nan, nan)},
	{complex(-inf, -zero), complex(-inf, -1), complex(nan, nan)},
	{complex(-inf, -zero), complex(-inf, 2), complex(nan, nan)},
	{complex(-inf, -zero), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, -zero), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, -zero), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, 1), complex(zero, zero), complex(-inf, inf)},
	{complex(-inf, 1), complex(zero, -zero), complex(-inf, inf)},
	{complex(-inf, 1), complex(zero, 1), complex(nan, inf)},
	{complex(-inf, 1), complex(zero, -1), complex(nan, -inf)},
	{complex(-inf, 1), complex(zero, 2), complex(nan, inf)},
	{complex(-inf, 1), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, 1), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, 1), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, 1), complex(zero, zero), complex(-inf, inf)},
	{complex(-inf, 1), complex(-zero, -zero), complex(inf, -inf)},
	{complex(-inf, 1), complex(zero, 1), complex(nan, inf)},
	{complex(-inf, 1), complex(-zero, -1), complex(nan, -inf)},
	{complex(-inf, 1), complex(zero, 2), complex(nan, inf)},
	{complex(-inf, 1), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, 1), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, 1), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, 1), complex(1, zero), complex(-inf, nan)},
	{complex(-inf, 1), complex(1, -zero), complex(-inf, nan)},
	{complex(-inf, 1), complex(1, 1), complex(-inf, inf)},
	{complex(-inf, 1), complex(1, -1), complex(-inf, -inf)},
	{complex(-inf, 1), complex(1, 2), complex(-inf, inf)},
	{complex(-inf, 1), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, 1), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, 1), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, 1), complex(-1, zero), complex(inf, nan)},
	{complex(-inf, 1), complex(-1, -zero), complex(inf, nan)},
	{complex(-inf, 1), complex(-1, 1), complex(inf, inf)},
	{complex(-inf, 1), complex(-1, -1), complex(inf, -inf)},
	{complex(-inf, 1), complex(-1, 2), complex(inf, inf)},
	{complex(-inf, 1), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, 1), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, 1), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, 1), complex(2, zero), complex(-inf, nan)},
	{complex(-inf, 1), complex(2, -zero), complex(-inf, nan)},
	{complex(-inf, 1), complex(2, 1), complex(-inf, inf)},
	{complex(-inf, 1), complex(2, -1), complex(-inf, -inf)},
	{complex(-inf, 1), complex(2, 2), complex(-inf, inf)},
	{complex(-inf, 1), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, 1), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, 1), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, 1), complex(nan, zero), complex(nan, nan)},
	{complex(-inf, 1), complex(nan, -zero), complex(nan, nan)},
	{complex(-inf, 1), complex(nan, 1), complex(nan, nan)},
	{complex(-inf, 1), complex(nan, -1), complex(nan, nan)},
	{complex(-inf, 1), complex(nan, 2), complex(nan, nan)},
	{complex(-inf, 1), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, 1), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, 1), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, 1), complex(inf, zero), complex(nan, nan)},
	{complex(-inf, 1), complex(inf, -zero), complex(nan, nan)},
	{complex(-inf, 1), complex(inf, 1), complex(nan, nan)},
	{complex(-inf, 1), complex(inf, -1), complex(nan, nan)},
	{complex(-inf, 1), complex(inf, 2), complex(nan, nan)},
	{complex(-inf, 1), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, 1), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, 1), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, 1), complex(-inf, zero), complex(nan, nan)},
	{complex(-inf, 1), complex(-inf, -zero), complex(nan, nan)},
	{complex(-inf, 1), complex(-inf, 1), complex(nan, nan)},
	{complex(-inf, 1), complex(-inf, -1), complex(nan, nan)},
	{complex(-inf, 1), complex(-inf, 2), complex(nan, nan)},
	{complex(-inf, 1), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, 1), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, 1), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, -1), complex(zero, zero), complex(-inf, -inf)},
	{complex(-inf, -1), complex(zero, -zero), complex(-inf, -inf)},
	{complex(-inf, -1), complex(zero, 1), complex(nan, inf)},
	{complex(-inf, -1), complex(zero, -1), complex(nan, -inf)},
	{complex(-inf, -1), complex(zero, 2), complex(nan, inf)},
	{complex(-inf, -1), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, -1), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, -1), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, -1), complex(zero, zero), complex(-inf, -inf)},
	{complex(-inf, -1), complex(-zero, -zero), complex(inf, inf)},
	{complex(-inf, -1), complex(zero, 1), complex(nan, inf)},
	{complex(-inf, -1), complex(-zero, -1), complex(nan, -inf)},
	{complex(-inf, -1), complex(zero, 2), complex(nan, inf)},
	{complex(-inf, -1), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, -1), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, -1), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, -1), complex(1, zero), complex(-inf, nan)},
	{complex(-inf, -1), complex(1, -zero), complex(-inf, nan)},
	{complex(-inf, -1), complex(1, 1), complex(-inf, inf)},
	{complex(-inf, -1), complex(1, -1), complex(-inf, -inf)},
	{complex(-inf, -1), complex(1, 2), complex(-inf, inf)},
	{complex(-inf, -1), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, -1), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, -1), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, -1), complex(-1, zero), complex(inf, nan)},
	{complex(-inf, -1), complex(-1, -zero), complex(inf, nan)},
	{complex(-inf, -1), complex(-1, 1), complex(inf, inf)},
	{complex(-inf, -1), complex(-1, -1), complex(inf, -inf)},
	{complex(-inf, -1), complex(-1, 2), complex(inf, inf)},
	{complex(-inf, -1), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, -1), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, -1), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, -1), complex(2, zero), complex(-inf, nan)},
	{complex(-inf, -1), complex(2, -zero), complex(-inf, nan)},
	{complex(-inf, -1), complex(2, 1), complex(-inf, inf)},
	{complex(-inf, -1), complex(2, -1), complex(-inf, -inf)},
	{complex(-inf, -1), complex(2, 2), complex(-inf, inf)},
	{complex(-inf, -1), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, -1), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, -1), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, -1), complex(nan, zero), complex(nan, nan)},
	{complex(-inf, -1), complex(nan, -zero), complex(nan, nan)},
	{complex(-inf, -1), complex(nan, 1), complex(nan, nan)},
	{complex(-inf, -1), complex(nan, -1), complex(nan, nan)},
	{complex(-inf, -1), complex(nan, 2), complex(nan, nan)},
	{complex(-inf, -1), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, -1), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, -1), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, -1), complex(inf, zero), complex(nan, nan)},
	{complex(-inf, -1), complex(inf, -zero), complex(nan, nan)},
	{complex(-inf, -1), complex(inf, 1), complex(nan, nan)},
	{complex(-inf, -1), complex(inf, -1), complex(nan, nan)},
	{complex(-inf, -1), complex(inf, 2), complex(nan, nan)},
	{complex(-inf, -1), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, -1), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, -1), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, -1), complex(-inf, zero), complex(nan, nan)},
	{complex(-inf, -1), complex(-inf, -zero), complex(nan, nan)},
	{complex(-inf, -1), complex(-inf, 1), complex(nan, nan)},
	{complex(-inf, -1), complex(-inf, -1), complex(nan, nan)},
	{complex(-inf, -1), complex(-inf, 2), complex(nan, nan)},
	{complex(-inf, -1), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, -1), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, -1), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, 2), complex(zero, zero), complex(-inf, inf)},
	{complex(-inf, 2), complex(zero, -zero), complex(-inf, inf)},
	{complex(-inf, 2), complex(zero, 1), complex(nan, inf)},
	{complex(-inf, 2), complex(zero, -1), complex(nan, -inf)},
	{complex(-inf, 2), complex(zero, 2), complex(nan, inf)},
	{complex(-inf, 2), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, 2), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, 2), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, 2), complex(zero, zero), complex(-inf, inf)},
	{complex(-inf, 2), complex(-zero, -zero), complex(inf, -inf)},
	{complex(-inf, 2), complex(zero, 1), complex(nan, inf)},
	{complex(-inf, 2), complex(-zero, -1), complex(nan, -inf)},
	{complex(-inf, 2), complex(zero, 2), complex(nan, inf)},
	{complex(-inf, 2), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, 2), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, 2), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, 2), complex(1, zero), complex(-inf, nan)},
	{complex(-inf, 2), complex(1, -zero), complex(-inf, nan)},
	{complex(-inf, 2), complex(1, 1), complex(-inf, inf)},
	{complex(-inf, 2), complex(1, -1), complex(-inf, -inf)},
	{complex(-inf, 2), complex(1, 2), complex(-inf, inf)},
	{complex(-inf, 2), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, 2), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, 2), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, 2), complex(-1, zero), complex(inf, nan)},
	{complex(-inf, 2), complex(-1, -zero), complex(inf, nan)},
	{complex(-inf, 2), complex(-1, 1), complex(inf, inf)},
	{complex(-inf, 2), complex(-1, -1), complex(inf, -inf)},
	{complex(-inf, 2), complex(-1, 2), complex(inf, inf)},
	{complex(-inf, 2), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, 2), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, 2), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, 2), complex(2, zero), complex(-inf, nan)},
	{complex(-inf, 2), complex(2, -zero), complex(-inf, nan)},
	{complex(-inf, 2), complex(2, 1), complex(-inf, inf)},
	{complex(-inf, 2), complex(2, -1), complex(-inf, -inf)},
	{complex(-inf, 2), complex(2, 2), complex(-inf, inf)},
	{complex(-inf, 2), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, 2), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, 2), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, 2), complex(nan, zero), complex(nan, nan)},
	{complex(-inf, 2), complex(nan, -zero), complex(nan, nan)},
	{complex(-inf, 2), complex(nan, 1), complex(nan, nan)},
	{complex(-inf, 2), complex(nan, -1), complex(nan, nan)},
	{complex(-inf, 2), complex(nan, 2), complex(nan, nan)},
	{complex(-inf, 2), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, 2), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, 2), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, 2), complex(inf, zero), complex(nan, nan)},
	{complex(-inf, 2), complex(inf, -zero), complex(nan, nan)},
	{complex(-inf, 2), complex(inf, 1), complex(nan, nan)},
	{complex(-inf, 2), complex(inf, -1), complex(nan, nan)},
	{complex(-inf, 2), complex(inf, 2), complex(nan, nan)},
	{complex(-inf, 2), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, 2), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, 2), complex(nan, -inf), complex(nan, nan)},
	{complex(-inf, 2), complex(-inf, zero), complex(nan, nan)},
	{complex(-inf, 2), complex(-inf, -zero), complex(nan, nan)},
	{complex(-inf, 2), complex(-inf, 1), complex(nan, nan)},
	{complex(-inf, 2), complex(-inf, -1), complex(nan, nan)},
	{complex(-inf, 2), complex(-inf, 2), complex(nan, nan)},
	{complex(-inf, 2), complex(nan, nan), complex(nan, nan)},
	{complex(-inf, 2), complex(nan, inf), complex(nan, nan)},
	{complex(-inf, 2), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(zero, zero), complex(nan, nan)},
	{complex(nan, nan), complex(zero, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(zero, 1), complex(nan, nan)},
	{complex(nan, nan), complex(zero, -1), complex(nan, nan)},
	{complex(nan, nan), complex(zero, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(zero, zero), complex(nan, nan)},
	{complex(nan, nan), complex(-zero, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(zero, 1), complex(nan, nan)},
	{complex(nan, nan), complex(-zero, -1), complex(nan, nan)},
	{complex(nan, nan), complex(zero, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(1, zero), complex(nan, nan)},
	{complex(nan, nan), complex(1, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(1, 1), complex(nan, nan)},
	{complex(nan, nan), complex(1, -1), complex(nan, nan)},
	{complex(nan, nan), complex(1, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(-1, zero), complex(nan, nan)},
	{complex(nan, nan), complex(-1, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(-1, 1), complex(nan, nan)},
	{complex(nan, nan), complex(-1, -1), complex(nan, nan)},
	{complex(nan, nan), complex(-1, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(2, zero), complex(nan, nan)},
	{complex(nan, nan), complex(2, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(2, 1), complex(nan, nan)},
	{complex(nan, nan), complex(2, -1), complex(nan, nan)},
	{complex(nan, nan), complex(2, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, zero), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(nan, 1), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -1), complex(nan, nan)},
	{complex(nan, nan), complex(nan, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(inf, zero), complex(nan, nan)},
	{complex(nan, nan), complex(inf, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(inf, 1), complex(nan, nan)},
	{complex(nan, nan), complex(inf, -1), complex(nan, nan)},
	{complex(nan, nan), complex(inf, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, zero), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, -zero), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, 1), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, -1), complex(nan, nan)},
	{complex(nan, nan), complex(-inf, 2), complex(nan, nan)},
	{complex(nan, nan), complex(nan, nan), complex(nan, nan)},
	{complex(nan, nan), complex(nan, inf), complex(nan, nan)},
	{complex(nan, nan), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(zero, zero), complex(nan, inf)},
	{complex(nan, inf), complex(zero, -zero), complex(nan, inf)},
	{complex(nan, inf), complex(zero, 1), complex(inf, nan)},
	{complex(nan, inf), complex(zero, -1), complex(-inf, nan)},
	{complex(nan, inf), complex(zero, 2), complex(inf, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(zero, zero), complex(nan, inf)},
	{complex(nan, inf), complex(-zero, -zero), complex(nan, -inf)},
	{complex(nan, inf), complex(zero, 1), complex(inf, nan)},
	{complex(nan, inf), complex(-zero, -1), complex(-inf, nan)},
	{complex(nan, inf), complex(zero, 2), complex(inf, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(1, zero), complex(nan, inf)},
	{complex(nan, inf), complex(1, -zero), complex(nan, inf)},
	{complex(nan, inf), complex(1, 1), complex(inf, inf)},
	{complex(nan, inf), complex(1, -1), complex(-inf, inf)},
	{complex(nan, inf), complex(1, 2), complex(inf, inf)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(-1, zero), complex(nan, -inf)},
	{complex(nan, inf), complex(-1, -zero), complex(nan, -inf)},
	{complex(nan, inf), complex(-1, 1), complex(inf, -inf)},
	{complex(nan, inf), complex(-1, -1), complex(-inf, -inf)},
	{complex(nan, inf), complex(-1, 2), complex(inf, -inf)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(2, zero), complex(nan, inf)},
	{complex(nan, inf), complex(2, -zero), complex(nan, inf)},
	{complex(nan, inf), complex(2, 1), complex(inf, inf)},
	{complex(nan, inf), complex(2, -1), complex(-inf, inf)},
	{complex(nan, inf), complex(2, 2), complex(inf, inf)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, zero), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -zero), complex(nan, nan)},
	{complex(nan, inf), complex(nan, 1), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -1), complex(nan, nan)},
	{complex(nan, inf), complex(nan, 2), complex(nan, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(inf, zero), complex(nan, nan)},
	{complex(nan, inf), complex(inf, -zero), complex(nan, nan)},
	{complex(nan, inf), complex(inf, 1), complex(nan, nan)},
	{complex(nan, inf), complex(inf, -1), complex(nan, nan)},
	{complex(nan, inf), complex(inf, 2), complex(nan, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, zero), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, -zero), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, 1), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, -1), complex(nan, nan)},
	{complex(nan, inf), complex(-inf, 2), complex(nan, nan)},
	{complex(nan, inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(zero, zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(zero, -zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(zero, 1), complex(-inf, nan)},
	{complex(nan, -inf), complex(zero, -1), complex(inf, nan)},
	{complex(nan, -inf), complex(zero, 2), complex(-inf, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(zero, zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(-zero, -zero), complex(nan, inf)},
	{complex(nan, -inf), complex(zero, 1), complex(-inf, nan)},
	{complex(nan, -inf), complex(-zero, -1), complex(inf, nan)},
	{complex(nan, -inf), complex(zero, 2), complex(-inf, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(1, zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(1, -zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(1, 1), complex(-inf, -inf)},
	{complex(nan, -inf), complex(1, -1), complex(inf, -inf)},
	{complex(nan, -inf), complex(1, 2), complex(-inf, -inf)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(-1, zero), complex(nan, inf)},
	{complex(nan, -inf), complex(-1, -zero), complex(nan, inf)},
	{complex(nan, -inf), complex(-1, 1), complex(-inf, inf)},
	{complex(nan, -inf), complex(-1, -1), complex(inf, inf)},
	{complex(nan, -inf), complex(-1, 2), complex(-inf, inf)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(2, zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(2, -zero), complex(nan, -inf)},
	{complex(nan, -inf), complex(2, 1), complex(-inf, -inf)},
	{complex(nan, -inf), complex(2, -1), complex(inf, -inf)},
	{complex(nan, -inf), complex(2, 2), complex(-inf, -inf)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, zero), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -zero), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, 1), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -1), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, 2), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, zero), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, -zero), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, 1), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, -1), complex(nan, nan)},
	{complex(nan, -inf), complex(inf, 2), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, zero), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, -zero), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, 1), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, -1), complex(nan, nan)},
	{complex(nan, -inf), complex(-inf, 2), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, nan), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, inf), complex(nan, nan)},
	{complex(nan, -inf), complex(nan, -inf), complex(nan, nan)},
}
