static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Color To Alpha plug-in v1.0 by Seth Burgess, sjburges@gimp.org 1999/05/14  \n"
" *  with algorithm by clahey                                                  \n"
" * Copyright (C) 1995 Spencer Kimball and Peter Mattis                        \n"
" * Copyright (C) 2011 Robert Sasu <sasu.robert@gmail.com>                     \n"
" * Copyright (C) 2012 Øyvind Kolås <pippin@gimp.org>                        \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_color (color, _(\"Color\"), \"white\")                               \n"
"    description(_(\"The color to make transparent.\"))                        \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_FILTER                                                  \n"
"#define GEGL_OP_C_SOURCE color-to-alpha.c                                     \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <stdio.h>                                                            \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"input\",                            \n"
"                             babl_format (\"R'G'B'A float\"));                \n"
"  gegl_operation_set_format (operation, \"output\",                           \n"
"                             babl_format (\"R'G'B'A float\"));                \n"
"}                                                                             \n"
"                                                                              \n"
"/*                                                                            \n"
" * An excerpt from a discussion on #gimp that sheds some light on the ideas   \n"
" * behind the algorithm that is being used here.                              \n"
" *                                                                            \n"
" <clahey>   so if a1 > c1, a2 > c2, and a3 > c2 and a1 - c1 > a2-c2, a3-c3,   \n"
" then a1 = b1 * alpha + c1 * (1-alpha)                                        \n"
" So, maximizing alpha without taking b1 above 1 gives                         \n"
" a1 = alpha + c1(1-alpha) and therefore alpha = (a1-c1) / (1-c1).             \n"
" <sjburges> clahey: btw, the ordering of that a2, a3 in the white->alpha didn't\n"
" matter                                                                       \n"
" <clahey>   sjburges: You mean that it could be either a1, a2, a3 or          \n"
" a1, a3, a2?                                                                  \n"
" <sjburges> yeah                                                              \n"
" <sjburges> because neither one uses the other                                \n"
" <clahey>   sjburges: That's exactly as it should be.  They are both just     \n"
" getting reduced to the same amount, limited by the the darkest               \n"
" color.                                                                       \n"
" <clahey>   Then a2 = b2 * alpha + c2 * (1- alpha).  Solving for b2 gives     \n"
" b2 = (a1-c2)/alpha + c2.                                                     \n"
" <sjburges> yeah                                                              \n"
" <clahey>   That gives us are formula for if the background is darker than the\n"
" foreground? Yep.                                                             \n"
" <clahey>   Next if a1 < c1, a2 < c2, a3 < c3, and c1-a1 > c2-a2, c3-a3, and  \n"
" by our desired result a1 = b1 * alpha + c1 * (1-alpha),                      \n"
" we maximize alpha without taking b1 negative gives                           \n"
" alpha = 1 - a1 / c1.                                                         \n"
" <clahey>   And then again, b2 = (a2-c2) / alpha + c2 by the same formula.    \n"
" (Actually, I think we can use that formula for all cases, though             \n"
" it may possibly introduce rounding error.                                    \n"
" <clahey>   sjburges: I like the idea of using floats to avoid rounding error.\n"
" Good call.                                                                   \n"
"*/                                                                            \n"
"                                                                              \n"
"static void                                                                   \n"
"color_to_alpha (const gfloat *color,                                          \n"
"                const gfloat *src,                                            \n"
"                gfloat       *dst)                                            \n"
"{                                                                             \n"
"  gint i;                                                                     \n"
"  gfloat alpha[4];                                                            \n"
"                                                                              \n"
"  for (i=0; i<4; i++)                                                         \n"
"    dst[i] = src[i];                                                          \n"
"                                                                              \n"
"  alpha[3] = dst[3];                                                          \n"
"                                                                              \n"
"  for (i=0; i<3; i++)                                                         \n"
"    {                                                                         \n"
"      if (color[i] < 0.00001)                                                 \n"
"        alpha[i] = dst[i];                                                    \n"
"      else if (dst[i] > color[i] + 0.00001)                                   \n"
"        alpha[i] = (dst[i] - color[i]) / (1.0f - color[i]);                   \n"
"      else if (dst[i] < color[i] - 0.00001)                                   \n"
"        alpha[i] = (color[i] - dst[i]) / (color[i]);                          \n"
"      else                                                                    \n"
"        alpha[i] = 0.0f;                                                      \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (alpha[0] > alpha[1])                                                    \n"
"    {                                                                         \n"
"      if (alpha[0] > alpha[2])                                                \n"
"        dst[3] = alpha[0];                                                    \n"
"      else                                                                    \n"
"        dst[3] = alpha[2];                                                    \n"
"    }                                                                         \n"
"  else if (alpha[1] > alpha[2])                                               \n"
"    {                                                                         \n"
"      dst[3] = alpha[1];                                                      \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      dst[3] = alpha[2];                                                      \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (dst[3] < 0.00001)                                                       \n"
"    return;                                                                   \n"
"                                                                              \n"
"  for (i=0; i<3; i++)                                                         \n"
"    dst[i] = (dst[i] - color[i]) / dst[3] + color[i];                         \n"
"                                                                              \n"
"  dst[3] *= alpha[3];                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"#include \"opencl/gegl-cl.h\"                                                 \n"
"#include \"opencl/color-to-alpha.cl.h\"                                       \n"
"                                                                              \n"
"static GeglClRunData * cl_data = NULL;                                        \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_process (GeglOperation       *operation,                                   \n"
"            cl_mem              in,                                           \n"
"            cl_mem              out,                                          \n"
"            size_t              global_worksize,                              \n"
"            const GeglRectangle *roi,                                         \n"
"            gint                level)                                        \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  gfloat      color[4];                                                       \n"
"  gegl_color_get_pixel (o->color, babl_format (\"R'G'B'A float\"), color);    \n"
"                                                                              \n"
"  if (!cl_data)                                                               \n"
"    {                                                                         \n"
"      const char *kernel_name[] = {\"cl_color_to_alpha\",NULL};               \n"
"      cl_data = gegl_cl_compile_and_build (color_to_alpha_cl_source, kernel_name);\n"
"    }                                                                         \n"
"  if (!cl_data)                                                               \n"
"    return TRUE;                                                              \n"
"  else                                                                        \n"
"  {                                                                           \n"
"    cl_int cl_err = 0;                                                        \n"
"    cl_float4 f_color;                                                        \n"
"    f_color.s[0] = color[0];                                                  \n"
"    f_color.s[1] = color[1];                                                  \n"
"    f_color.s[2] = color[2];                                                  \n"
"    f_color.s[3] = color[3];                                                  \n"
"                                                                              \n"
"    cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 0,  sizeof(cl_mem),   (void*)&in);\n"
"    CL_CHECK;                                                                 \n"
"    cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 1,  sizeof(cl_mem),   (void*)&out);\n"
"    CL_CHECK;                                                                 \n"
"    cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 2,  sizeof(cl_float4),(void*)&f_color);\n"
"    CL_CHECK;                                                                 \n"
"                                                                              \n"
"    cl_err = gegl_clEnqueueNDRangeKernel(gegl_cl_get_command_queue (),        \n"
"                                         cl_data->kernel[0], 1,               \n"
"                                         NULL, &global_worksize, NULL,        \n"
"                                         0, NULL, NULL);                      \n"
"    CL_CHECK;                                                                 \n"
"  }                                                                           \n"
"                                                                              \n"
"  return  FALSE;                                                              \n"
"                                                                              \n"
" error:                                                                       \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         void                *in_buf,                                         \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o      = GEGL_PROPERTIES (operation);                       \n"
"  const Babl *format = babl_format (\"R'G'B'A float\");                       \n"
"  gfloat      color[4];                                                       \n"
"  gint        x;                                                              \n"
"                                                                              \n"
"  gfloat *in_buff = in_buf;                                                   \n"
"  gfloat *out_buff = out_buf;                                                 \n"
"                                                                              \n"
"  gegl_color_get_pixel (o->color, format, color);                             \n"
"                                                                              \n"
"  for (x = 0; x < n_pixels; x++)                                              \n"
"    {                                                                         \n"
"      color_to_alpha (color, in_buff, out_buff);                              \n"
"      in_buff  += 4;                                                          \n"
"      out_buff += 4;                                                          \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointFilterClass *filter_class;                                \n"
"  gchar                         *composition =                                \n"
"    \"<?xml version='1.0' encoding='UTF-8'?>\"                                \n"
"    \"<gegl>\"                                                                \n"
"    \"<node operation='svg:dst-over'>\"                                       \n"
"    \"  <node operation='gegl:crop'>\"                                        \n"
"    \"    <params>\"                                                          \n"
"    \"      <param name='width'>200.0</param>\"                               \n"
"    \"      <param name='height'>200.0</param>\"                              \n"
"    \"    </params>\"                                                         \n"
"    \"  </node>\"                                                             \n"
"    \"  <node operation='gegl:checkerboard'>\"                                \n"
"    \"    <params><param name='color1'>rgb(0.5, 0.5, 0.5)</param></params>\"  \n"
"    \"  </node>\"                                                             \n"
"    \"</node>\"                                                               \n"
"    \"<node operation='gegl:color-to-alpha'>\"                                \n"
"    \"</node>\"                                                               \n"
"    \"<node operation='gegl:load'>\"                                          \n"
"    \"  <params>\"                                                            \n"
"    \"    <param name='path'>standard-input.png</param>\"                     \n"
"    \"  </params>\"                                                           \n"
"    \"</node>\"                                                               \n"
"    \"</gegl>\";                                                              \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_POINT_FILTER_CLASS (klass);                \n"
"                                                                              \n"
"  filter_class->process    = process;                                         \n"
"  filter_class->cl_process = cl_process;                                      \n"
"                                                                              \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->opencl_support = TRUE;                                     \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:color-to-alpha\",                                 \n"
"    \"title\",       _(\"Color to Alpha\"),                                   \n"
"    \"categories\",  \"color\",                                               \n"
"    \"license\",     \"GPL3+\",                                               \n"
"    \"description\", _(\"Convert a specified color to transparency, works best with white.\"),\n"
"    \"reference-composition\", composition,                                   \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
