import struct, os

class AuditMsg:
    header_format="iiii"
    header_size = struct.calcsize(header_format)

    def __init__(self):
        self.version  = 0
        self.size     = AuditMsg.header_size
        self.msg_type = None
        self.length   = None
        self.body     = None
        self.log = False
        
    def read_from_fd(self, fd):
        # Read the header
        header = ''
        self.body = ''
        while len(header) < AuditMsg.header_size:
            new_data = os.read(fd, AuditMsg.header_size - len(header))
            if len(new_data) == 0:
                return False
            header += new_data

        # Parse the header
        self.version, self.size, self.msg_type, self.length = \
                      struct.unpack(AuditMsg.header_format, header)

        # Read the body now that we know how long it is.
        while len(self.body) < self.length:
            new_data = os.read(fd, self.length - len(self.body))
            if len(new_data) == 0:
                return False
            self.body += new_data

        return True

    def set_version(self, version):
        self.version = version

    def get_version(self):
        return self.version

    def set_msg_type(self, msg_type):
        self.msg_type = msg_type

    def get_msg_type(self):
        return self.msg_type

    def set_body(self, body):
        self.body = body
        self.length = len(self.body)

    def get_body(self):
        return self.body

    def get_type(self):
        return self.msg_type

    def set_length(self, length):
        raise ValueError("setting length is side effect of setting body")
    
    def get_length(self):
        return self.length

    def set(self, msg_type, body):
        self.set_msg_type(msg_type)
        self.set_body(body)

    def get_header(self):
        self.length = len(self.body)
        return struct.pack(AuditMsg.header_format,
                           self.version, self.size, self.msg_type, self.length)

    def binary(self):
        return self.get_header() + self.get_body()
