# This file was created by configpm when Perl was built. Any changes
# made to this file will be lost the next time perl is built.

package Config;
use strict;
# use warnings; Pulls in Carp
# use vars pulls in Carp
@Config::EXPORT = qw(%Config);
@Config::EXPORT_OK = qw(myconfig config_sh config_vars config_re);

# Need to stub all the functions to make code such as print Config::config_sh
# keep working

sub myconfig;
sub config_sh;
sub config_vars;
sub config_re;

my %Export_Cache = map {($_ => 1)} (@Config::EXPORT, @Config::EXPORT_OK);

our %Config;

# Define our own import method to avoid pulling in the full Exporter:
sub import {
    my $pkg = shift;
    @_ = @Config::EXPORT unless @_;

    my @funcs = grep $_ ne '%Config', @_;
    my $export_Config = @funcs < @_ ? 1 : 0;

    no strict 'refs';
    my $callpkg = caller(0);
    foreach my $func (@funcs) {
	die sprintf qq{"%s" is not exported by the %s module\n},
	    $func, __PACKAGE__ unless $Export_Cache{$func};
	*{$callpkg.'::'.$func} = \&{$func};
    }

    *{"$callpkg\::Config"} = \%Config if $export_Config;
    return;
}

die "Perl lib version (v5.8.9) doesn't match executable version ($])"
    unless $^V;

$^V eq v5.8.9
    or die "Perl lib version (v5.8.9) doesn't match executable version (" .
	sprintf("v%vd",$^V) . ")";


sub FETCH {
    my($self, $key) = @_;

    # check for cached value (which may be undef so we use exists not defined)
    return $self->{$key} if exists $self->{$key};

    # ALT: avoid dummy keys (e.g. XML__Parser_cflags)
    return undef if $key =~ /_cflags\z/;

    # ALT: this is how we would like to grab some more keys:
#   print STDERR "\nConfig.pm: fetch $key\n" 
#	if $ENV{RPM_PACKAGE_NAME} and $ENV{RPM_PACKAGE_NAME} ne "perl";
    return $self->fetch_string($key);
}
sub TIEHASH {
    bless $_[1], $_[0];
}

sub DESTROY { }

sub AUTOLOAD {
    require 'Config_heavy.pl';
    goto \&launcher unless $Config::AUTOLOAD =~ /launcher$/;
    die "&Config::AUTOLOAD failed on $Config::AUTOLOAD";
}

# tie returns the object, so the value returned to require will be true.
tie %Config, 'Config', {
    ar => 'ar',
    archlibexp => '/usr/lib/perl5/i386-linux',
    archname => 'i386-linux-thread-multi',
    bincompat5005 => undef,
    binexp => '/usr/bin',
    cc => 'gcc',
    cccdlflags => '-fPIC -DPIC',
    ccdlflags => '-rdynamic -Wl,-O1',
    ccflags => '-D_REENTRANT -D_GNU_SOURCE -DTHREADS_HAVE_PIDS -fno-strict-aliasing -pipe -I/usr/local/include -D_LARGEFILE_SOURCE -D_FILE_OFFSET_BITS=64 -I/usr/include/gdbm',
    cpprun => 'gcc -E',
    d_flexfnam => 'define',
    d_link => 'define',
    d_readlink => 'define',
    d_symlink => 'define',
    dlext => 'so',
    dlsrc => 'dl_dlopen.xs',
    dont_use_nlink => undef,
    eunicefix => ':',
    exe_ext => '',
    full_ar => '/usr/bin/ar',
    inc_version_list => '5.8.8/i386-linux 5.8.7/i386-linux 5.8.6/i386-linux 5.8.5/i386-linux 5.8.4/i386-linux 5.8.3/i386-linux 5.8.2/i386-linux 5.8.1/i386-linux 5.8.0/i386-linux 5.8.8 5.8.7 5.8.6 5.8.5 5.8.4 5.8.3 5.8.2 5.8.1 5.8.0 5.6.1 5.6.0',
    installarchlib => '/usr/lib/perl5/i386-linux',
    installbin => '/usr/bin',
    installman1dir => '/usr/share/man/man1',
    installman3dir => '/usr/share/man/man3',
    installprefixexp => '/usr',
    installprivlib => '/usr/lib/perl5',
    installscript => '/usr/bin',
    installsitearch => '/usr/local/lib/perl5/site_perl/5.8.9/i386-linux',
    installsitebin => '/usr/local/bin',
    installsitelib => '/usr/local/lib/perl5/site_perl/5.8.9',
    installsiteman1dir => '/usr/local/man/man1',
    installsiteman3dir => '/usr/local/share/man/man3',
    installstyle => 'lib/perl5',
    installvendorarch => '/usr/lib/perl5/vendor_perl/i386-linux',
    installvendorbin => '/usr/bin',
    installvendorlib => '/usr/lib/perl5/vendor_perl',
    installvendorman1dir => '/usr/share/man/man1',
    installvendorman3dir => '/usr/share/man/man3',
    intsize => '4',
    ld => 'gcc',
    lddlflags => '-shared -Wl,-O1 -L/usr/local/lib',
    ldflags => '-Wl,-O1 -L/usr/local/lib',
    ldlibpthname => 'LD_LIBRARY_PATH',
    lib_ext => '.a',
    libc => '/lib/libc-2.10.1.so',
    libperl => 'libperl.so.5.8',
    libpth => '/usr/local/lib /lib /usr/lib',
    make => 'make',
    man1ext => '1',
    man3ext => '3pm',
    obj_ext => '.o',
    optimize => '-pipe -Wall -O2 -march=i586 -mtune=i686 -D_GNU_SOURCE',
    osname => 'linux',
    osvers => '2.6.18-ovz-rhel-alt7',
    path_sep => ':',
    perllibs => '-ldl -lm -lpthread -lc -lcrypt',
    perlpath => '/usr/bin/perl',
    privlibexp => '/usr/lib/perl5',
    ranlib => ':',
    scriptdir => '/usr/bin',
    sh => '/bin/sh',
    sharpbang => '#!',
    shellflags => undef,
    sitearchexp => '/usr/local/lib/perl5/site_perl/5.8.9/i386-linux',
    sitelibexp => '/usr/local/lib/perl5/site_perl/5.8.9',
    siteprefixexp => '/usr/local',
    so => 'so',
    startperl => '#!/usr/bin/perl',
    usedl => 'define',
    useithreads => 'define',
    usemymalloc => 'n',
    usesocks => undef,
    usethreads => 'define',
    usevendorprefix => 'define',
    vendorarchexp => '/usr/lib/perl5/vendor_perl/i386-linux',
    vendorlibexp => '/usr/lib/perl5/vendor_perl',
    vendorprefixexp => '/usr',
    version => '5.8.9',
};
