#!/usr/bin/tclsh

set docdir [lindex $argv 0]
set manuals {}

foreach docfile [glob -nocomplain -directory $docdir *.html] {
    puts stderr $docfile

    if {[catch {set fd [open $docfile]} msg]} {
	puts stderr "Can't open file $docfile: $msg"
	continue
    }

    while {[gets $fd line] >= 0} {
	if {[regexp {<h1[^>]*>\s*(.*)\((3tcl)?\)\s+(\S+)\s+(\S+)\s+(.*)</h1>} $line -> \
		    name - version module title]} {
	    lappend manuals [list $module!$title!$name $module $name $version $title [file tail $docfile]]
	    break
	}
    }
    close $fd
}

puts "<html>
<head>
<title>Tcllib HTML Documentation</title>
<style type=\"text/css\">
<!--
ul {
    background: #80ffff;
    border-style: solid;
    border-width: 1px;
    border-color: black;
}
li {
    padding: 3px;
}
li a {
    font-weight: bold;
}
h1, h2, h3, h4 {
    margin-top: 1em;
    font-family: sans-serif;
    font-size: large;
    color: #005A9C;
    background: transparent;
    text-align: left;
}
-->
</style>
</head>
<body>
<h1>Tcllib HTML Documentation</h1>"

set manuals [lsort -index 0 $manuals]
set prev ""
set prevtitle ""
foreach m $manuals {
    set module  [lindex $m 1]
    set name    [lindex $m 2]
    set version [lindex $m 3]
    set title   [lindex $m 4]
    set fname   [lindex $m 5]

    if {$module != $prev} {
	if {$prev != ""} {
	    puts "</ul>"
	}
	puts "<h2>$module: $title</h2>\n<ul>"
	set prev $module
	set prevtitle $title
    } elseif {$title != $prevtitle} {
	puts "</ul>\n<h2>$module: $title</h2>\n<ul>"
	set prevtitle $title
    }
    puts "<li><a href=\"html/$fname\">$name</a> $version</li>"
}
puts "</ul>
</body>
</html>"

