; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; Test that the stpcpy library call simplifier works correctly.
; RUN: opt < %s -passes=instcombine -S | FileCheck %s
;
; This transformation requires the pointer size, as it assumes that size_t is
; the size of a pointer.
target datalayout = "e-p:32:32:32-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:32:64-f32:32:32-f64:32:64-v64:64:64-v128:128:128-a0:0:64-f80:128:128-n8:16:32"

@hello = constant [6 x i8] c"hello\00"
@a = common global [32 x i8] zeroinitializer, align 1
@b = common global [32 x i8] zeroinitializer, align 1
@percent_s = constant [3 x i8] c"%s\00"

declare ptr @stpcpy(ptr, ptr)

define ptr @test_simplify1() {
; CHECK-LABEL: @test_simplify1(
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr noundef nonnull align 1 dereferenceable(6) @a, ptr noundef nonnull align 1 dereferenceable(6) @hello, i32 6, i1 false)
; CHECK-NEXT:    ret ptr getelementptr inbounds ([32 x i8], ptr @a, i32 0, i32 5)
;
  %ret = call ptr @stpcpy(ptr @a, ptr @hello)
  ret ptr %ret
}

define ptr @test_simplify2() {
; CHECK-LABEL: @test_simplify2(
; CHECK-NEXT:    [[STRLEN:%.*]] = call i32 @strlen(ptr noundef nonnull dereferenceable(1) @a)
; CHECK-NEXT:    [[RET:%.*]] = getelementptr inbounds i8, ptr @a, i32 [[STRLEN]]
; CHECK-NEXT:    ret ptr [[RET]]
;
  %ret = call ptr @stpcpy(ptr @a, ptr @a)
  ret ptr %ret
}

define void @test_simplify3(ptr %dst) {
; CHECK-LABEL: @test_simplify3(
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr noundef nonnull align 1 dereferenceable(6) [[DST:%.*]], ptr noundef nonnull align 1 dereferenceable(6) @hello, i32 6, i1 false)
; CHECK-NEXT:    ret void
;
  call ptr @stpcpy(ptr dereferenceable(80) %dst, ptr @hello)
  ret void
}

define ptr @test_no_simplify1() {
; CHECK-LABEL: @test_no_simplify1(
; CHECK-NEXT:    [[RET:%.*]] = call ptr @stpcpy(ptr nonnull @a, ptr nonnull @b)
; CHECK-NEXT:    ret ptr [[RET]]
;
  %ret = call ptr @stpcpy(ptr @a, ptr @b)
  ret ptr %ret
}

define ptr @test_no_simplify2(ptr %dst, ptr %src) {
; CHECK-LABEL: @test_no_simplify2(
; CHECK-NEXT:    [[RET:%.*]] = musttail call ptr @stpcpy(ptr [[DST:%.*]], ptr [[SRC:%.*]])
; CHECK-NEXT:    ret ptr [[RET]]
;
  %ret = musttail call ptr @stpcpy(ptr %dst, ptr %src)
  ret ptr %ret
}

define ptr @test_no_incompatible_attr() {
; CHECK-LABEL: @test_no_incompatible_attr(
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr noundef nonnull align 1 dereferenceable(6) @a, ptr noundef nonnull align 1 dereferenceable(6) @hello, i32 6, i1 false)
; CHECK-NEXT:    ret ptr getelementptr inbounds ([32 x i8], ptr @a, i32 0, i32 5)
;
  %ret = call dereferenceable(1) ptr @stpcpy(ptr @a, ptr @hello)
  ret ptr %ret
}
