/*
    digipanel.h - A user-space program to write to the ASUS DigiMatrix
                  front panel.
    Copyright (c) 2005 Richard Taylor <richard@artaylor.co.uk>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* Some info gathered about the registers:
00 - 1st Digit
01 - 2nd
02 - 3rd
03 - 4th
04 - 5th
05 - 6th

06 - Colon 1, 2, 3 (bottom, middle, both)
07 - Not sure...
08 - Show play symbol
09 - Show pause symbol
10 -
11 - HD Mode (HD Symbol)
12 - CD Mode (CD Symbol)
13 - FM Mode (FM + Radio on)
14 - AM Mode (AM + Radio on)
15 - Turns off Radio / Current mode? (Doesn't clear icon)

16 - Radio Next Preset
17 - Radio Prev Preset
18 -
19 - Radio Seek Up

21 - Store station (select number)
22 - Store station (cancel)
25 - Store station (store)

30 - Hour (Hex e.g. 0x23 = 11pm)
31 - Minute

33 - Reads back the value written...
34 - Displays temperature (hex value written).
35 - Go back to digit mode (resets to -- --:--)

36 - Volume control count (8-bit +/-)
37 - Radio: manual tune up (+0.5 MHz)
38 - Radio: manual tune down (-0.5 MHz)
39 - Radio: seek down
40 -

41 - Display time

Don't go above 86 - the I2C bus freezes!
*/

/* Update intervals for temperature display and volume control in ms */
#define TEMP_UPDATE_INTERVAL_MS   500
#define VOL_UPDATE_INTERVAL_MS    150

int digipanel_main(int argc, char *argv[]);
int digiradio_main(int argc, char *argv[]);
