/*
 *  acm - Virtual terminal
 *  Copyright (C) 2007 Umberto Salsi
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 dated June, 1991.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program;  if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave., Cambridge, MA 02139, USA.
 */

/*
	This module implements a textual terminal where commands from the
	users can be accepted and outputs can be displayed.  Every terminal
	is attached to a viewer data structure. Mostly useful for debugging
	at run-time.
*/

#ifndef _terminal_h
#define _terminal_h

#include "pm.h"

#ifdef terminal_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif

/*
	Enable/ disable/ toggle the terminal.
*/
EXTERN void terminal_toggle(viewer *u);
EXTERN void terminal_enable(viewer *u);
EXTERN void terminal_disable(viewer *u);

/*
	Return TRUE if the terminal is currently enabled
*/
EXTERN _BOOL terminal_enabled(viewer *u);

/*
	Send this char to the terminal
*/
EXTERN void terminal_input_char(viewer *u, int ch);

/*
	Return TRUE if a complete line of input from the terminal is
	available. The string is returned in the buffer s, s_len bytes long.
*/
EXTERN _BOOL terminal_read_string(viewer *u, char *s, int s_len);

/*
	Send the string to the terminal. Recognized control codes are:
	NL \n, CR \r, HT \t, BS \010. Any other control char is ignored.
	Coded above 127 are displayed as "?".
*/
EXTERN void terminal_write(viewer *u, char *s);

/*
	If the terminal is currently active, display its contents
*/
EXTERN void terminal_draw(viewer *u);

/*
	Disable and release the internal memory for this terminal.  Internal
	buffers are not actually released, as thay may be re-used next for
	a new terminal. To actually release the occupied memory the next
	function can be called.
*/
EXTERN void terminal_free(viewer *u);

#undef EXTERN
#endif
